/*
 * Decompiled with CFR 0.152.
 */
package com.colloquial.arithcode;

import com.colloquial.arithcode.AdaptiveUnigramModel;
import com.colloquial.arithcode.ArithCodeInputStream;
import com.colloquial.arithcode.ArithCodeModel;
import com.colloquial.arithcode.ArithCodeOutputStream;
import com.colloquial.arithcode.PPMModel;
import com.colloquial.arithcode.TestSet;
import com.colloquial.arithcode.UniformModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Random;

public final class Test {
    private static TestSet _testSet = new TestSet();

    public static void main(String[] args) throws IOException {
        System.out.println();
        System.out.println("Start Time: " + new Timestamp(System.currentTimeMillis()));
        long startTime = System.currentTimeMillis();
        _testSet.clear();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-f")) {
                Test.test(new File(args[++i]));
                continue;
            }
            if (args[i].equals("-s")) {
                Test.testSize(Integer.parseInt(args[++i]));
                continue;
            }
            if (args[i].equals("-c")) {
                Test.testCalgary(args[++i]);
                continue;
            }
            if (args[i].equals("-x")) {
                Test.testXML(args[++i]);
                continue;
            }
            if (args[i].equals("-g")) {
                Test.testFixed();
                continue;
            }
            Test.test(args[i]);
        }
        System.out.println();
        System.out.print("Total Time: " + Test.timeToSeconds(Test.elapsed(startTime)));
        System.out.println(_testSet);
    }

    static void copyStream(InputStream in, OutputStream out) throws IOException {
        while (true) {
            int j;
            if ((j = in.read()) == -1) {
                in.close();
                out.close();
                return;
            }
            out.write(j);
        }
    }

    static long elapsed(long start) {
        return System.currentTimeMillis() - start;
    }

    static String timeToSeconds(long t) {
        return (double)t / 1000.0 + " seconds";
    }

    private Test() {
    }

    private static void testSize(int size) throws IOException {
        StringBuffer constantSB = new StringBuffer("a");
        Random random = new Random();
        for (int k = 1; k <= size; k *= 2) {
            byte[] bs = new byte[k];
            Test.nextRandomAlphaNum(bs, random);
            Test.test(bs);
            random.nextBytes(bs);
            Test.test(bs);
            String constantString = constantSB.toString();
            Test.test(constantString.toString());
            constantSB.append(constantSB.toString());
        }
    }

    private static void testFixed() throws IOException {
        Test.test("");
        Test.test("The quick brown fox jumped over the lazy dog.");
        Test.test("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
        Test.test("01234567890~`!@#$%^&*()-_=+{[}]:;\"'<,>.?/|\\.abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ.");
    }

    private static void testXML(String path) throws IOException {
        Test.test(new File(path, "play1.xml"));
        Test.test(new File(path, "treebank.xml"));
        Test.test(new File(path, "w3c2.xml"));
        Test.test(new File(path, "w3c3.xml"));
        Test.test(new File(path, "weblog.xml"));
        Test.test(new File(path, "tpc.xml"));
        Test.test(new File(path, "sprot.xml"));
        Test.test(new File(path, "elts.xml"));
        Test.test(new File(path, "stats1.xml"));
        Test.test(new File(path, "pcc2.xml"));
        Test.test(new File(path, "tal1.xml"));
    }

    private static void testCalgary(String path) throws IOException {
        Test.test(new File(path, "progc"));
        Test.test(new File(path, "progl"));
        Test.test(new File(path, "progp"));
        Test.test(new File(path, "paper1"));
        Test.test(new File(path, "paper2"));
        Test.test(new File(path, "book1"));
        Test.test(new File(path, "book2"));
        Test.test(new File(path, "news"));
        Test.test(new File(path, "bib"));
        Test.test(new File(path, "trans"));
        Test.test(new File(path, "obj1"));
        Test.test(new File(path, "obj2"));
        Test.test(new File(path, "geo"));
        Test.test(new File(path, "pic"));
    }

    private static boolean test(File file) throws IOException {
        System.out.println("\nTesting File: " + file);
        FileInputStream in = new FileInputStream(file);
        int available = in.available();
        byte[] bytes = new byte[available];
        in.read(bytes, 0, available);
        return Test.testBytes(bytes);
    }

    private static boolean test(String text) throws IOException {
        System.out.println();
        System.out.println("Testing: /" + Test.trim(text) + "/");
        return Test.testBytes(text.getBytes());
    }

    private static boolean test(byte[] bytes) throws IOException {
        System.out.println();
        System.out.println("Testing byte array with length: " + bytes.length);
        return Test.testBytes(bytes);
    }

    private static boolean testPPMBytes(byte[] bytes, int order) throws IOException {
        return Test.testBytes(bytes, new PPMModel(order), new PPMModel(order), "PPM(" + order + ")" + (order < 10 ? "  " : " "));
    }

    private static boolean testBytes(byte[] bytes) throws IOException {
        boolean pass = true;
        pass = Test.testBytes(bytes, UniformModel.MODEL, UniformModel.MODEL, "Uniform ") && pass;
        pass = Test.testBytes(bytes, new AdaptiveUnigramModel(), new AdaptiveUnigramModel(), "Unigram ") && pass;
        pass = Test.testPPMBytes(bytes, 0) && pass;
        pass = Test.testPPMBytes(bytes, 1) && pass;
        pass = Test.testPPMBytes(bytes, 2) && pass;
        pass = Test.testPPMBytes(bytes, 3) && pass;
        pass = Test.testPPMBytes(bytes, 4) && pass;
        pass = Test.testPPMBytes(bytes, 5) && pass;
        pass = Test.testPPMBytes(bytes, 6) && pass;
        pass = Test.testPPMBytes(bytes, 7) && pass;
        pass = Test.testPPMBytes(bytes, 8) && pass;
        pass = Test.testPPMBytes(bytes, 10) && pass;
        pass = Test.testPPMBytes(bytes, 12) && pass;
        pass = Test.testPPMBytes(bytes, 16) && pass;
        return pass;
    }

    private static boolean testBytes(byte[] bytes, ArithCodeModel modelIn, ArithCodeModel modelOut, String name) throws IOException {
        ByteArrayInputStream textBytesIn = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream codeBytesOut = new ByteArrayOutputStream();
        long startTime = System.currentTimeMillis();
        Test.copyStream(textBytesIn, new ArithCodeOutputStream(codeBytesOut, modelIn));
        long encodeTime = Test.elapsed(startTime);
        modelIn = null;
        ByteArrayOutputStream textBytesOut = new ByteArrayOutputStream();
        byte[] codeBytes = codeBytesOut.toByteArray();
        startTime = System.currentTimeMillis();
        Test.copyStream(new ArithCodeInputStream(new ByteArrayInputStream(codeBytes), modelOut), textBytesOut);
        long decodeTime = Test.elapsed(startTime);
        _testSet.record(name, bytes.length, codeBytes.length, encodeTime, decodeTime);
        boolean pass = Arrays.equals(bytes, textBytesOut.toByteArray());
        System.out.print("  " + name + " ");
        System.out.print(Test.intToString(bytes.length, 9) + " -> " + Test.intToString(codeBytes.length, 9) + " B");
        System.out.print("  " + Test.compressionRateString(bytes.length, codeBytes.length));
        System.out.print("  enc: " + Test.speedString(bytes.length, encodeTime));
        System.out.print("  dec: " + Test.speedString(bytes.length, decodeTime));
        System.out.println(pass ? "" : "***** FAIL *****");
        return pass;
    }

    private static String compressionRateString(int numBytesIn, int numBytesOut) {
        String result;
        double val = (double)((int)(1000.0 * ((double)numBytesOut * 8.0 / (double)numBytesIn))) / 1000.0;
        String string = result = val > 1000.0 ? "?" : val + "";
        while (result.length() < 6) {
            result = result + " ";
        }
        return result + "b/B";
    }

    private static String intToString(int n, int minLength) {
        String s = Integer.toString(n);
        while (s.length() < minLength) {
            s = ' ' + s;
        }
        return s;
    }

    private static String speedString(int numBytes, long numMillis) {
        int kbS = (int)((double)numBytes / (double)numMillis);
        return (kbS > 100000 ? "     ?" : Test.intToString(kbS, 6)) + " kB/s";
    }

    private static String trim(String in) {
        return in.length() <= 32 ? in : in.substring(0, 32) + "...";
    }

    private static void nextRandomAlphaNum(byte[] bs, Random r) {
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = Test.nextRandomAlphaNum(r);
        }
    }

    private static byte nextByteRange(Random r, int low, int high) {
        return (byte)(low + r.nextInt(1 + high - low));
    }

    private static byte nextRandomAlphaNum(Random r) {
        if (r.nextBoolean()) {
            return Test.nextByteRange(r, 97, 122);
        }
        if (r.nextBoolean()) {
            return Test.nextByteRange(r, 65, 90);
        }
        return Test.nextByteRange(r, 48, 57);
    }
}

