/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.butterfly;

import edu.mit.simile.butterfly.ButterflyClassLoaderWatcher;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ButterflyClassLoader
extends URLClassLoader {
    private static final Logger _logger = LoggerFactory.getLogger((String)"butterfly.classloader");
    private ButterflyClassLoaderWatcher _watcher;

    public ButterflyClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public TimerTask getClassLoaderWatcher(Runnable trigger) {
        if (this._watcher == null) {
            this._watcher = new ButterflyClassLoaderWatcher(trigger);
        }
        return this._watcher;
    }

    public void addRepository(File repository) {
        _logger.trace("> Processing class repository: {}", (Object)repository);
        if (repository.exists()) {
            if (repository.isDirectory()) {
                File[] jars = repository.listFiles();
                try {
                    _logger.trace("Adding folder: {}", (Object)repository);
                    super.addURL(repository.toURI().toURL());
                    if (this._watcher != null) {
                        this._watcher.addFile(repository);
                    }
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e.toString());
                }
                for (int i = 0; i < jars.length; ++i) {
                    if (!jars[i].getAbsolutePath().endsWith(".jar")) continue;
                    this.addJar(jars[i]);
                }
            } else {
                this.addJar(repository);
            }
        } else {
            _logger.info("Repository {} does not exist", (Object)repository);
        }
        _logger.trace("< Processing class repository: {}", (Object)repository);
    }

    public void watch(File file) {
        if (this._watcher != null) {
            this._watcher.watch(file);
        }
    }

    private void addJar(File file) {
        try {
            URL url = file.toURI().toURL();
            _logger.trace("Adding jar: {}", (Object)file);
            super.addURL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }
}

