/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.butterfly;

import edu.mit.simile.butterfly.ButterflyClassLoader;
import edu.mit.simile.butterfly.ButterflyModule;
import edu.mit.simile.butterfly.ButterflyModuleImpl;
import edu.mit.simile.butterfly.ButterflyMounter;
import edu.mit.simile.butterfly.ButterflyScriptWatcher;
import edu.mit.simile.butterfly.ButterflyScriptableObject;
import edu.mit.simile.butterfly.MountPoint;
import edu.mit.simile.butterfly.Zone;
import edu.mit.simile.butterfly.velocity.ButterflyResourceLoader;
import edu.mit.simile.butterfly.velocity.Super;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.app.VelocityEngine;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Butterfly
extends HttpServlet {
    public static final String HOST_HEADER = "X-Forwarded-Host";
    public static final String CONTEXT_HEADER = "X-Context-Path";
    private static final long serialVersionUID = 1938797827088619577L;
    private static final long watcherDelay = 1000L;
    public static final String NAME = "butterfly.name";
    public static final String APPENGINE = "butterfly.appengine";
    public static final String AUTORELOAD = "butterfly.autoreload";
    public static final String HOME = "butterfly.home";
    public static final String ZONE = "butterfly.zone";
    public static final String BASE_URL = "butterfly.url";
    public static final String DEFAULT_ZONE = "butterfly.default.zone";
    public static final String DEFAULT_MOUNTPOINT = "butterfly.default.mountpoint";
    public static final String MODULES_IGNORE = "butterfly.modules.ignore";
    public static final String MODULES_PATH = "butterfly.modules.path";
    public static final String MAIN_ZONE = "main";
    static final List<String> CONTROLLER = new ArrayList<String>();
    private transient Logger _logger;
    private boolean _autoreload;
    private boolean _appengine;
    private String _name;
    private String _default_mountpoint;
    private int _routingCookieMaxAge;
    private String[] _ignores;
    protected transient Timer _timer;
    protected transient ButterflyClassLoader _classLoader;
    protected transient ButterflyScriptWatcher _scriptWatcher;
    protected transient ServletConfig _config;
    protected transient ServletContext _context;
    protected transient ButterflyMounter _mounter;
    protected ExtendedProperties _properties;
    protected File _contextDir;
    protected File _homeDir;
    protected File _webInfDir;
    protected Exception _configurationException;
    protected boolean _configured = false;
    protected ContextFactory contextFactory;
    private static final String dependencyPrefix = "requires";
    private static final String implementsProperty = "implements";
    private static final String extendsProperty = "extends";
    protected Map<String, ButterflyModule> _modulesByName = new HashMap<String, ButterflyModule>();
    protected Map<String, Map<String, ButterflyModule>> _modulesByInterface = new HashMap<String, Map<String, ButterflyModule>>();
    protected Map<String, ExtendedProperties> _moduleProperties = new HashMap<String, ExtendedProperties>();
    protected Map<String, Boolean> _created = new HashMap<String, Boolean>();
    private static final String routingCookie = "host";
    protected static final String PATH_PROP = "__path__";
    String header = "<html> <head> </head> <body>";
    String footer = "</body></html>";

    public static String getTrueHost(HttpServletRequest request) {
        String host = request.getHeader(HOST_HEADER);
        if (host != null) {
            String[] hosts = host.split(",");
            host = hosts[hosts.length - 1];
        }
        return host;
    }

    public static String getTrueContextPath(HttpServletRequest request, boolean absolute) {
        String context = request.getHeader(CONTEXT_HEADER);
        if (context != null) {
            if (context.charAt(context.length() - 1) == '/') {
                context = context.substring(0, context.length() - 1);
            }
        } else {
            context = request.getContextPath();
        }
        if (absolute) {
            return Butterfly.getFullHost(request) + context;
        }
        return context;
    }

    public static String getTrueRequestURI(HttpServletRequest request, boolean absolute) {
        return Butterfly.getTrueContextPath(request, absolute) + request.getPathInfo();
    }

    public static String getFullHost(HttpServletRequest request) {
        StringBuffer prefix = new StringBuffer();
        String protocol = request.getScheme();
        prefix.append(protocol);
        prefix.append("://");
        String proxy = Butterfly.getTrueHost(request);
        if (proxy != null) {
            prefix.append(proxy);
        } else {
            prefix.append(request.getServerName());
            int port = request.getServerPort();
            if (!(protocol.equals("http") && port == 80 || protocol.equals("https") && port == 443)) {
                prefix.append(':');
                prefix.append(port);
            }
        }
        return prefix.toString();
    }

    public static boolean isGAE(ServletConfig config) {
        return config.getServletContext().getServerInfo().indexOf("Google App Engine") != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._config = config;
        this._appengine = Butterfly.isGAE(config);
        this._name = System.getProperty(NAME, "butterfly");
        this._context = config.getServletContext();
        this._context.setAttribute(NAME, (Object)this._name);
        this._context.setAttribute(APPENGINE, (Object)this._appengine);
        this._contextDir = new File(this._context.getRealPath("/"));
        this._webInfDir = new File(this._contextDir, "WEB-INF");
        this._properties = new ExtendedProperties();
        this._mounter = new ButterflyMounter();
        String props = System.getProperty("butterfly.properties");
        File butterflyProperties = props == null ? new File(this._webInfDir, "butterfly.properties") : new File(props);
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(butterflyProperties));
            this._properties.load((InputStream)is);
        }
        catch (FileNotFoundException e) {
            throw new ServletException("Could not find butterfly properties file", (Throwable)e);
        }
        catch (IOException e) {
            throw new ServletException("Could not read butterfly properties file", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        String includes = this._properties.getString("butterfly.includes");
        if (includes != null) {
            void var8_16;
            String[] stringArray = includes.split(",");
            int n = stringArray.length;
            boolean bl = false;
            while (var8_16 < n) {
                String prop = stringArray[var8_16];
                File prop_file = prop.startsWith("/") ? new File(prop) : new File(this._webInfDir, prop);
                try {
                    is = new BufferedInputStream(new FileInputStream(prop_file));
                    ExtendedProperties p = new ExtendedProperties();
                    p.load((InputStream)is);
                    this._properties.combine(p);
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
                ++var8_16;
            }
        }
        Properties systemProperties = System.getProperties();
        for (String string : systemProperties.keySet()) {
            String value = systemProperties.getProperty(string);
            this._properties.setProperty(string, (Object)value);
        }
        this._default_mountpoint = this._properties.getString(DEFAULT_MOUNTPOINT, "/modules");
        this._ignores = this._properties.getString(MODULES_IGNORE, "").split(",");
        this._autoreload = this._properties.getBoolean(AUTORELOAD, false);
        this._logger = LoggerFactory.getLogger((String)this._name);
        this._logger.info("Starting {} ...", (Object)this._name);
        this._logger.info("Properties loaded from {}", (Object)butterflyProperties);
        if (this._autoreload) {
            this._logger.info("Autoreloading is enabled");
        }
        if (this._appengine) {
            this._logger.info("Running in Google App Engine");
        }
        this._logger.debug("> init");
        this._logger.debug("> initialize classloader");
        try {
            this._classLoader = AccessController.doPrivileged(new PrivilegedAction<ButterflyClassLoader>(){

                @Override
                public ButterflyClassLoader run() {
                    return new ButterflyClassLoader(this.getClass().getClassLoader());
                }
            });
            Thread.currentThread().setContextClassLoader(this._classLoader);
            this._classLoader.watch(butterflyProperties);
            this.contextFactory = new ButterflyContextFactory();
            this.contextFactory.initApplicationClassLoader((ClassLoader)this._classLoader);
            ContextFactory.initGlobal((ContextFactory)this.contextFactory);
            if (this._autoreload && !this._appengine) {
                this._timer = new Timer(true);
                TimerTask classloaderWatcher = this._classLoader.getClassLoaderWatcher(new Trigger(this._contextDir));
                this._timer.schedule(classloaderWatcher, 1000L, 1000L);
            }
        }
        catch (Exception e) {
            throw new ServletException("Failed to load butterfly classloader", (Throwable)e);
        }
        this._logger.debug("< initialize classloader");
        if (this._autoreload && !this._appengine) {
            this._logger.debug("> initialize script watcher");
            this._scriptWatcher = new ButterflyScriptWatcher();
            this._timer.schedule((TimerTask)this._scriptWatcher, 1000L, 1000L);
            this._logger.debug("< initialize script watcher");
        }
        this.configure();
        this._logger.debug("< init");
    }

    public void destroy() {
        this._logger.info("Stopping Butterfly...");
        for (ButterflyModule m : this._modulesByName.values()) {
            try {
                this._logger.debug("> destroying {}", (Object)m);
                m.destroy();
                this._logger.debug("< destroying {}", (Object)m);
            }
            catch (Exception e) {
                this._logger.error("Exception caught while destroying '" + m + "'", (Throwable)e);
            }
        }
        if (this._timer != null) {
            this._timer.cancel();
        }
        this._logger.info("done.");
    }

    public void configure() {
        this._logger.debug("> configure");
        this._logger.info("> process properties");
        try {
            String timeZone;
            String homePath = this._properties.getString(HOME);
            this._homeDir = homePath == null ? this._contextDir : new File(homePath);
            this._logger.info("Butterfly home: {}", (Object)this._homeDir);
            Iterator i = this._properties.getKeys(ZONE);
            while (i.hasNext()) {
                String zone = (String)i.next();
                String path = this._properties.getString(zone);
                zone = zone.substring(ZONE.length() + 1);
                this._logger.info("Zone path: [{}] -> {}", (Object)zone, (Object)path);
                this._mounter.registerZone(zone, path);
            }
            String defaultZone = this._properties.getString(DEFAULT_ZONE);
            if (defaultZone != null) {
                this._logger.info("Default zone is: '{}'", (Object)defaultZone);
                this._mounter.setDefaultZone(defaultZone);
            } else {
                String baseURL = this._properties.getString(BASE_URL, "/");
                this._mounter.registerZone(MAIN_ZONE, baseURL);
                this._mounter.setDefaultZone(MAIN_ZONE);
            }
            String language = this._properties.getString("butterfly.locale.language");
            String country = this._properties.getString("butterfly.locale.country");
            String variant = this._properties.getString("butterfly.locale.variant");
            if (language != null) {
                if (country != null) {
                    if (variant != null) {
                        Locale.setDefault(new Locale(language, country, variant));
                    } else {
                        Locale.setDefault(new Locale(language, country));
                    }
                } else {
                    Locale.setDefault(new Locale(language));
                }
            }
            if ((timeZone = this._properties.getString("butterfly.timeZone")) != null) {
                TimeZone.setDefault(TimeZone.getTimeZone(timeZone));
            }
            this._routingCookieMaxAge = this._properties.getInt("butterfly.routing.cookie.maxage", -1);
        }
        catch (Exception e) {
            this._configurationException = new Exception("Failed to load butterfly properties", e);
        }
        this._logger.info("< process properties");
        this._logger.info("> load modules");
        List paths = this._properties.getList(MODULES_PATH);
        for (Object path : paths) {
            this.findModulesIn(this.absolutize(this._homeDir, ((String)path).trim()));
        }
        String servlet_paths = this._config.getInitParameter(MODULES_PATH);
        if (servlet_paths != null) {
            for (String path : servlet_paths.split(",")) {
                this.findModulesIn(this.absolutize(this._homeDir, path.trim()));
            }
        }
        this._logger.info("< load modules");
        this._logger.info("> create modules");
        for (String name : this._moduleProperties.keySet()) {
            this.createModule(name);
        }
        this._logger.info("< create modules");
        this._logger.info("> load module wirings");
        ExtendedProperties wirings = new ExtendedProperties();
        try {
            File moduleWirings = this.absolutize(this._homeDir, this._properties.getString("butterfly.modules.wirings", "WEB-INF/modules.properties"));
            this._logger.info("Loaded module wirings from: {}", (Object)moduleWirings);
            this._classLoader.watch(moduleWirings);
            FileInputStream fis = new FileInputStream(moduleWirings);
            wirings.load((InputStream)fis);
            fis.close();
        }
        catch (Exception e) {
            this._configurationException = new Exception("Failed to load module wirings", e);
        }
        this._logger.info("< load module wirings");
        this._logger.info("> wire modules");
        try {
            this.wireModules(wirings);
        }
        catch (Exception e) {
            this._configurationException = new Exception("Failed to wire modules", e);
        }
        this._logger.info("< wire modules");
        this._logger.info("> configure modules");
        try {
            this.configureModules();
        }
        catch (Exception e) {
            this._configurationException = new Exception("Failed to configure modules", e);
        }
        this._logger.info("< configure modules");
        this._logger.info("> initialize modules");
        HashSet<String> initialized = new HashSet<String>();
        HashSet<String> initializing = new HashSet<String>();
        for (String name : this._modulesByName.keySet()) {
            this.initializeModule(name, initialized, initializing);
        }
        this._logger.info("< initialize modules");
        this._configured = true;
        this._logger.debug("< configure");
    }

    protected void initializeModule(String name, Set<String> initialized, Set<String> initializing) {
        ButterflyModule m = this._modulesByName.get(name);
        if (m != null && !initialized.contains(name)) {
            this._logger.debug("> initialize " + m.getName());
            if (initializing.contains(name)) {
                this._logger.warn("Circular dependencies detected involving module " + m);
            } else {
                initializing.add(name);
                for (String depends : m.getDependencies().keySet()) {
                    this.initializeModule(depends, initialized, initializing);
                }
                initializing.remove(name);
            }
            try {
                m.init(this.getServletConfig());
            }
            catch (Exception e) {
                this._configurationException = new Exception("Failed to initialize module: " + m, e);
            }
            catch (NoClassDefFoundError e) {
                this._configurationException = new Exception("Failed to initialize module (missing Java class definition): " + m, e);
            }
            this._logger.debug("< initialize " + m.getName());
            initialized.add(name);
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = request.getMethod();
        String path = request.getPathInfo();
        String urlQuery = request.getQueryString();
        if (this._mounter != null) {
            Zone zone = this._mounter.getZone(request);
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("> " + method + " [" + (zone != null ? zone.getName() : "") + "] " + path + (urlQuery != null ? "?" + urlQuery : ""));
                Enumeration en = request.getHeaderNames();
                while (en.hasMoreElements()) {
                    String header = (String)en.nextElement();
                    this._logger.trace("{}: {}", (Object)header, (Object)request.getHeader(header));
                }
            } else if (this._logger.isInfoEnabled()) {
                String zoneName = zone != null ? zone.getName() : "";
                this._logger.info("{} {} [{}]", (Object[])new String[]{method, path, zoneName});
            }
            this.setRoutingCookie(request, response);
            try {
                if (this._configured) {
                    if (this._configurationException == null) {
                        ButterflyModule module = this._mounter.getModule(path, zone);
                        this._logger.debug("Module '{}' will handle the request", (Object)module.getName());
                        String localPath = module.getRelativePath(request);
                        if (!module.process(localPath, request, response)) {
                            response.sendError(404);
                        }
                    } else {
                        this.error(response, "Butterfly Error", "Butterfly incurred in the following errors while initializing:", this._configurationException);
                    }
                } else {
                    this.delay(response, "Butterfly is still initializing...");
                }
            }
            catch (FileNotFoundException e) {
                response.sendError(404);
            }
            catch (Exception e) {
                this.error(response, "Butterfly Error", "Butterfly caught the following error while processing the request:", e);
            }
            response.flushBuffer();
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("< " + method + " [" + (zone != null ? zone.getName() : "") + "] " + path + (urlQuery != null ? "?" + urlQuery : ""));
            }
        } else {
            response.sendError(503);
        }
    }

    protected void setRoutingCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!routingCookie.equals(cookie.getName())) continue;
                return;
            }
        }
        Cookie cookie = new Cookie(routingCookie, "." + this._name);
        cookie.setMaxAge(this._routingCookieMaxAge);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    protected File absolutize(File base, String location) {
        if (location == null || location.length() == 0) {
            return base;
        }
        if (location.indexOf(58) > 0) {
            return new File(location);
        }
        if (location.charAt(0) == '/' || location.charAt(0) == '\\') {
            return new File(location);
        }
        return new File(base, location);
    }

    protected void findModulesIn(File f) {
        this._logger.debug("look for modules in {}", (Object)f);
        File modFile = new File(f, "MOD-INF");
        if (modFile.exists()) {
            this._logger.trace("> findModulesIn({})", (Object)f);
            try {
                String name = f.getName();
                ExtendedProperties p = new ExtendedProperties();
                File propFile = new File(modFile, "module.properties");
                if (propFile.exists()) {
                    this._classLoader.watch(propFile);
                    BufferedInputStream stream = new BufferedInputStream(new FileInputStream(propFile));
                    p.load((InputStream)stream);
                    stream.close();
                }
                p.addProperty(PATH_PROP, (Object)f.getAbsolutePath());
                if (p.containsKey((Object)"name")) {
                    name = p.getString("name");
                }
                boolean load = true;
                for (String s : this._ignores) {
                    if (!name.matches(s)) continue;
                    load = false;
                    break;
                }
                if (load) {
                    this._moduleProperties.put(name, p);
                }
            }
            catch (Exception e) {
                this._logger.error("Error finding module wirings", (Throwable)e);
            }
            this._logger.trace("< findModulesIn({})", (Object)f);
        } else {
            File[] files = f.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    try {
                        if (!file.isDirectory()) continue;
                        this.findModulesIn(file);
                        continue;
                    }
                    catch (AccessControlException accessControlException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected ButterflyModule createModule(String name) {
        File libs;
        this._logger.trace("> Creating module: {}", (Object)name);
        if (this._modulesByName.containsKey(name)) {
            this._logger.trace("< Module '{}' already exists", (Object)name);
            return this._modulesByName.get(name);
        }
        ExtendedProperties p = this._moduleProperties.get(name);
        File path = new File(p.getString(PATH_PROP));
        this._logger.debug("Module path: {}", (Object)path);
        File classes = new File(path, "MOD-INF/classes");
        if (classes.exists()) {
            this._classLoader.addRepository(classes);
        }
        if ((libs = new File(path, "MOD-INF/lib")).exists()) {
            this._classLoader.addRepository(libs);
        }
        ButterflyModule m = new ButterflyModuleImpl();
        String manager = p.getString("module-impl");
        if (manager != null && !manager.equals(m.getClass().getName())) {
            try {
                Class<?> c = this._classLoader.loadClass(manager);
                m = (ButterflyModule)c.newInstance();
            }
            catch (Exception e) {
                this._logger.error("Error loading special module manager", (Throwable)e);
            }
        }
        m.setName(name);
        m.setPath(path);
        m.setModules(this._modulesByName);
        m.setMounter(this._mounter);
        m.setClassLoader(this._classLoader);
        m.setTimer(this._timer);
        this._modulesByName.put(name, m);
        ButterflyModule parentModule = null;
        String parentName = p.getString(extendsProperty);
        if (parentName != null) {
            if (this._moduleProperties.containsKey(parentName)) {
                parentModule = this._modulesByName.containsKey(parentName) ? this._modulesByName.get(parentName) : this.createModule(parentName);
            } else {
                throw new RuntimeException("Cannot wire module '" + name + "' because the extended module '" + parentName + "' is not defined.");
            }
        }
        if (parentModule != null) {
            m.setExtended(parentModule);
            parentModule.addExtendedBy(m);
        }
        this._logger.trace("< Creating module: {}", (Object)name);
        return m;
    }

    protected void wireModules(ExtendedProperties wirings) {
        ButterflyModule m;
        this._logger.trace("> wireModules()");
        this._logger.info("mounting modules");
        for (String name : this._moduleProperties.keySet()) {
            MountPoint mountPoint;
            this._logger.trace("> Mounting module: {}", (Object)name);
            m = this._modulesByName.get(name);
            String mountPointStr = wirings.getString(m.getName());
            if (mountPointStr == null) {
                String moduleName = m.getName();
                String mountPoint2 = this._default_mountpoint + "/" + m.getName();
                this._logger.info("No mount point defined for module '" + moduleName + "', mounting to '" + mountPoint2 + "'");
                mountPointStr = mountPoint2;
            }
            if (this._mounter.isRegistered(mountPoint = new MountPoint(mountPointStr))) {
                throw new RuntimeException("Cannot have two different modules with the same mount point '" + mountPoint + "'.");
            }
            this._mounter.register(mountPoint, m);
            this._logger.trace("< Mounting module: {}", (Object)name);
        }
        for (String name : this._moduleProperties.keySet()) {
            this._logger.trace("> Expanding properties for module: {}", (Object)name);
            m = this._modulesByName.get(name);
            ExtendedProperties p = this._moduleProperties.get(name);
            for (ButterflyModule extended = m.getExtendedModule(); extended != null; extended = extended.getExtendedModule()) {
                this._logger.trace("> Merging properties from extended module: {}", (Object)name);
                ExtendedProperties temp = p;
                p = this._moduleProperties.get(extended.getName());
                p.combine(temp);
                this._logger.trace("< Merging properties from extended module: {} -> {}", (Object)name, (Object)p);
            }
            this._moduleProperties.put(name, p);
            List implementations = p.getList(implementsProperty);
            if (implementations != null) {
                for (String i : implementations) {
                    Map<String, ButterflyModule> map = this._modulesByInterface.get(i);
                    if (map == null) {
                        map = new HashMap<String, ButterflyModule>();
                        this._modulesByInterface.put(i, map);
                    }
                    map.put(name, m);
                    m.setImplementation(i);
                }
            }
            this._logger.trace("< Expanding properties for module: {}", (Object)name);
        }
        for (String name : this._moduleProperties.keySet()) {
            this._logger.trace("> Inject dependencies in module: {}", (Object)name);
            ExtendedProperties p = this._moduleProperties.get(name);
            ButterflyModule m2 = this._modulesByName.get(name);
            for (Object o : p.keySet()) {
                String s = (String)o;
                if (!s.equals(dependencyPrefix)) continue;
                for (Object oo : p.getList(s)) {
                    String dep = (String)oo;
                    this._logger.trace("> Processing dependency: {}", (Object)dep);
                    dep = dep.trim();
                    Map<String, ButterflyModule> modules = this._modulesByInterface.get(dep);
                    if (modules != null) {
                        if (modules.size() == 1) {
                            this.setDependency(m2, dep, modules.values().iterator().next());
                        } else {
                            ButterflyModule parent = m2.getExtendedModule();
                            do {
                                String wiredDependency;
                                if ((wiredDependency = wirings.getString(name + "." + dep)) != null) {
                                    this.setDependency(m2, dep, this._modulesByName.get(wiredDependency));
                                    break;
                                }
                                if (parent == null) continue;
                                name = parent.getName();
                            } while (parent != null);
                        }
                    } else {
                        throw new RuntimeException("Cannot wire module '" + name + "' because no module implements the required interface '" + dep + "'");
                    }
                    this._logger.trace("< Processing dependency: {}", (Object)dep);
                }
            }
            this._logger.trace("< Inject dependencies in module: {}", (Object)name);
        }
        ButterflyModule rootModule = this._mounter.getRootModule();
        if (rootModule == null) {
            rootModule = this._modulesByName.get(MAIN_ZONE);
        }
        if (rootModule == null) {
            throw new RuntimeException("Cannot initialize the modules because I can't guess which module to mount to '/'");
        }
        this._logger.trace("< wireModules()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureModules() {
        this._logger.trace("> configureModules()");
        for (String name : this._moduleProperties.keySet()) {
            block23: {
                this._logger.trace("> Configuring module: {}", (Object)name);
                ExtendedProperties p = this._moduleProperties.get(name);
                ButterflyModule m = this._modulesByName.get(name);
                m.setProperties(this._properties);
                try {
                    List scriptables;
                    if (p.getBoolean("templating", Boolean.TRUE).booleanValue()) {
                        this._logger.trace("> enabling templating");
                        Properties properties = new Properties();
                        File velocityProperties = new File(this._webInfDir, "velocity.properties");
                        this._classLoader.watch(velocityProperties);
                        FileInputStream fis = new FileInputStream(velocityProperties);
                        properties.load(fis);
                        fis.close();
                        properties.setProperty("resource.loader", "butterfly");
                        properties.setProperty("butterfly.resource.loader.class", ButterflyResourceLoader.class.getName());
                        properties.setProperty("butterfly.resource.loader.cache", "true");
                        properties.setProperty("butterfly.resource.loader.modificationCheckInterval", "1");
                        properties.setProperty("butterfly.resource.loader.description", "Butterfly Resource Loader");
                        properties.setProperty("velocimacro.library", p.getString("templating.macros", ""));
                        properties.setProperty("userdirective", Super.class.getName());
                        if (this._appengine) {
                            properties.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.JdkLogChute");
                        } else {
                            properties.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.Log4JLogChute");
                            properties.setProperty("runtime.log.logsystem.log4j.logger", "velocity");
                        }
                        VelocityEngine velocity = new VelocityEngine();
                        velocity.setApplicationAttribute((Object)"module", (Object)m);
                        velocity.init(properties);
                        m.setTemplateEngine(velocity);
                        this._logger.trace("< enabling templating");
                    }
                    if ((scriptables = p.getList("scriptables")).size() > 0) {
                        Context context = Context.enter();
                        BufferedReader initializerReader = null;
                        for (String scriptable : scriptables) {
                            if (scriptable.equals("")) continue;
                            try {
                                this._logger.trace("> adding scriptable object: {}", (Object)scriptable);
                                Class<?> c = this._classLoader.loadClass(scriptable);
                                ButterflyScriptableObject o = (ButterflyScriptableObject)((Object)c.newInstance());
                                this.setScriptable(m, o);
                                URL initializer = c.getResource("init.js");
                                if (initializer != null) {
                                    initializerReader = new BufferedReader(new InputStreamReader(initializer.openStream()));
                                    Butterfly.setScript(m, initializer, context.compileReader((Reader)initializerReader, "init.js", 1, null));
                                    this._scriptWatcher.watch(initializer, m);
                                    this._logger.trace("Parsed scriptable javascript initializer successfully");
                                }
                                this._logger.trace("< adding scriptable object: {}", (Object)scriptable);
                            }
                            catch (Exception e) {
                                this._logger.trace("Error initializing scriptable object '{}': {}", (Object)scriptable, (Object)e);
                            }
                            finally {
                                if (initializerReader == null) continue;
                                initializerReader.close();
                            }
                        }
                        Context.exit();
                    }
                    List controllers = p.getList("controller", CONTROLLER);
                    HashSet<URL> controllerURLs = new HashSet<URL>(controllers.size());
                    for (String controller : controllers) {
                        URL controllerURL = m.getResource("MOD-INF/" + controller);
                        if (controllerURL == null) continue;
                        controllerURLs.add(controllerURL);
                    }
                    if (controllerURLs.size() <= 0) break block23;
                    this._logger.trace("> enabling javascript control");
                    Context context = Context.enter();
                    try (BufferedReader initializerReader = null;){
                        URL initializer = ((Object)((Object)this)).getClass().getClassLoader().getResource("edu/mit/simile/butterfly/Butterfly.js");
                        initializerReader = new BufferedReader(new InputStreamReader(initializer.openStream()));
                        Butterfly.setScript(m, initializer, context.compileReader((Reader)initializerReader, "Butterfly.js", 1, null));
                        this.watch(initializer, m);
                        this._logger.trace("Parsed javascript initializer successfully");
                    }
                    BufferedReader controllerReader = null;
                    for (URL controllerURL : controllerURLs) {
                        try {
                            controllerReader = new BufferedReader(new InputStreamReader(controllerURL.openStream()));
                            Butterfly.setScript(m, controllerURL, context.compileReader((Reader)controllerReader, controllerURL.toString(), 1, null));
                            this.watch(controllerURL, m);
                            this._logger.trace("Parsed javascript controller successfully: {}", (Object)controllerURL);
                        }
                        finally {
                            if (controllerReader == null) continue;
                            controllerReader.close();
                        }
                    }
                    Context.exit();
                    this._logger.trace("< enabling javascript control");
                }
                catch (Exception e) {
                    this._logger.error("Error enabling javascript control", (Throwable)e);
                }
            }
            this._logger.trace("< Configuring module: {}", (Object)name);
        }
        this._logger.trace("< configureModules()");
    }

    protected void setDependency(ButterflyModule subj, String dep, ButterflyModule obj) {
        subj.setDependency(dep, obj);
        ButterflyModule extended = subj.getExtendedModule();
        if (extended != null) {
            this.setDependency(extended, dep, obj);
        }
    }

    protected void setScriptable(ButterflyModule mod, ButterflyScriptableObject scriptable) {
        mod.setScriptable(scriptable);
        ButterflyModule extended = mod.getExtendedModule();
        if (extended != null) {
            this.setScriptable(extended, scriptable);
        }
    }

    protected void watch(URL script, ButterflyModule module) throws IOException {
        if (this._scriptWatcher != null) {
            this._scriptWatcher.watch(script, module);
        }
    }

    protected void delay(HttpServletResponse response, String title) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        writer.println(this.header);
        writer.println("<h1>" + title + "</h1>");
        writer.println("<script>setTimeout(function() { window.location = '.' }, 3000);</script>");
        writer.println(this.footer);
        writer.close();
    }

    protected void error(HttpServletResponse response, String title, String msg, Exception e) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.println(title);
        writer.println(msg);
        if (e != null) {
            e.printStackTrace(writer);
        }
        writer.close();
        response.sendError(500, stringWriter.toString());
    }

    protected static void setScript(ButterflyModule mod, URL location, Script script) {
        mod.setScript(location, script);
        ButterflyModule extended = mod.getExtendedModule();
        if (extended != null) {
            Butterfly.setScript(extended, location, script);
        }
    }

    static {
        CONTROLLER.add("controller.js");
    }

    private static class Trigger
    implements Runnable {
        private static final Logger _logger = LoggerFactory.getLogger((String)"butterfly.trigger");
        private List<File> tries = new ArrayList<File>();

        Trigger(File context) {
            File libs;
            File web_inf = new File(context, "WEB-INF");
            File classes = new File(web_inf, "classes");
            if (classes.exists()) {
                this.tries.add(this.findFile(classes, ".class"));
            }
            if ((libs = new File(web_inf, "lib")).exists()) {
                this.tries.add(this.findFile(libs, ".jar"));
            }
        }

        @Override
        public void run() {
            _logger.info("classloader changed trigger invoked");
            for (File f : this.tries) {
                _logger.debug("trying: " + f.getAbsolutePath());
                if (!f.exists()) continue;
                f.setLastModified(new Date().getTime());
                _logger.debug(" touched!!");
                return;
            }
            _logger.warn("could not find anything to touch");
        }

        private File findFile(File start, String extension) {
            for (File f : start.listFiles()) {
                if (f.isDirectory()) {
                    return this.findFile(f, extension);
                }
                if (!f.getName().endsWith(extension)) continue;
                return f;
            }
            return null;
        }
    }

    class ButterflyContextFactory
    extends ContextFactory {
        ButterflyContextFactory() {
        }

        protected void onContextCreated(Context cx) {
            cx.setOptimizationLevel(9);
            super.onContextCreated(cx);
        }
    }
}

