/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.butterfly;

import edu.mit.simile.butterfly.Butterfly;
import edu.mit.simile.butterfly.ButterflyModule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import org.mozilla.javascript.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ButterflyScriptWatcher
extends TimerTask {
    private static final Logger _logger = LoggerFactory.getLogger((String)"butterfly.script_watcher");
    private Map<URL, ButterflyModule> scripts = new HashMap<URL, ButterflyModule>();
    private Map<URL, Long> lastModifieds = new HashMap<URL, Long>();

    ButterflyScriptWatcher() {
    }

    protected void watch(URL script, ButterflyModule module) throws IOException {
        _logger.debug("Watching {}", (Object)script);
        this.lastModifieds.put(script, script.openConnection().getLastModified());
        this.scripts.put(script, module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            ArrayList<URL> urls = new ArrayList<URL>(this.scripts.keySet());
            for (URL url : urls) {
                URLConnection connection = url.openConnection();
                long lastModified = connection.getLastModified();
                if (lastModified > this.lastModifieds.get(url)) {
                    _logger.debug("{} has changed, reparsing...", (Object)url);
                    this.lastModifieds.put(url, lastModified);
                    ButterflyModule module = this.scripts.get(url);
                    try (BufferedReader reader = null;){
                        Context context = Context.enter();
                        reader = new BufferedReader(new InputStreamReader(url.openStream()));
                        Butterfly.setScript(module, url, context.compileReader((Reader)reader, url.getFile(), 1, null));
                        _logger.info("{} reloaded", (Object)url);
                        Context.exit();
                    }
                }
                connection.getInputStream().close();
            }
        }
        catch (Exception e) {
            _logger.error("", (Throwable)e);
        }
    }
}

