/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.Arrays;
import org.marc4j.MarcPermissiveStreamReader;
import org.marc4j.MarcReader;
import org.marc4j.marc.Record;

public class MarcDirStreamReader
implements MarcReader {
    File[] list;
    MarcReader curFileReader;
    int curFileNum;
    boolean permissive;
    boolean convertToUTF8;
    String defaultEncoding;

    public MarcDirStreamReader(String dirName) {
        File dir = new File(dirName);
        this.init(dir, false, false, null);
    }

    public MarcDirStreamReader(File dir) {
        this.init(dir, false, false, null);
    }

    public MarcDirStreamReader(String dirName, boolean permissive, boolean convertToUTF8) {
        File dir = new File(dirName);
        this.init(dir, permissive, convertToUTF8, null);
    }

    public MarcDirStreamReader(File dir, boolean permissive, boolean convertToUTF8) {
        this.init(dir, permissive, convertToUTF8, null);
    }

    public MarcDirStreamReader(String dirName, boolean permissive, boolean convertToUTF8, String defaultEncoding) {
        File dir = new File(dirName);
        this.init(dir, permissive, convertToUTF8, defaultEncoding);
    }

    public MarcDirStreamReader(File dir, boolean permissive, boolean convertToUTF8, String defaultEncoding) {
        this.init(dir, permissive, convertToUTF8, defaultEncoding);
    }

    private void init(File dir, boolean permissive, boolean convertToUTF8, String defaultEncoding) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith("mrc");
            }
        };
        this.permissive = permissive;
        this.convertToUTF8 = convertToUTF8;
        this.list = dir.listFiles(filter);
        Arrays.sort(this.list);
        this.curFileNum = 0;
        this.curFileReader = null;
        this.defaultEncoding = defaultEncoding;
    }

    public boolean hasNext() {
        if (this.curFileReader == null || !this.curFileReader.hasNext()) {
            this.nextFile();
        }
        return this.curFileReader == null ? false : this.curFileReader.hasNext();
    }

    private void nextFile() {
        block5: {
            if (this.curFileNum != this.list.length) {
                try {
                    System.err.println("Switching to input file: " + this.list[this.curFileNum]);
                    if (this.defaultEncoding != null) {
                        this.curFileReader = new MarcPermissiveStreamReader((InputStream)new FileInputStream(this.list[this.curFileNum++]), this.permissive, this.convertToUTF8, this.defaultEncoding);
                        break block5;
                    }
                    this.curFileReader = new MarcPermissiveStreamReader((InputStream)new FileInputStream(this.list[this.curFileNum++]), this.permissive, this.convertToUTF8);
                }
                catch (FileNotFoundException e) {
                    this.nextFile();
                }
            } else {
                this.curFileReader = null;
            }
        }
    }

    public Record next() {
        if (this.curFileReader == null || !this.curFileReader.hasNext()) {
            this.nextFile();
        }
        return this.curFileReader == null ? null : this.curFileReader.next();
    }
}

