/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.List;
import org.marc4j.MarcException;
import org.marc4j.MarcWriter;
import org.marc4j.converter.CharConverter;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;

public class MarcStreamWriter
implements MarcWriter {
    private OutputStream out = null;
    private String encoding = "ISO8859_1";
    private CharConverter converter = null;
    private static DecimalFormat format4 = new DecimalFormat("0000");
    private static DecimalFormat format5 = new DecimalFormat("00000");

    public MarcStreamWriter(OutputStream out) {
        this.out = out;
    }

    public MarcStreamWriter(OutputStream out, String encoding) {
        this.encoding = encoding;
        this.out = out;
    }

    public CharConverter getConverter() {
        return this.converter;
    }

    public void setConverter(CharConverter converter) {
        this.converter = converter;
    }

    public void write(Record record) {
        int previous = 0;
        try {
            ByteArrayOutputStream data = new ByteArrayOutputStream();
            ByteArrayOutputStream dir = new ByteArrayOutputStream();
            List fields = record.getControlFields();
            for (ControlField cf : fields) {
                data.write(this.getDataElement(cf.getData()));
                data.write(30);
                dir.write(this.getEntry(cf.getTag(), data.size() - previous, previous));
                previous = data.size();
            }
            fields = record.getDataFields();
            for (DataField df : fields) {
                data.write(df.getIndicator1());
                data.write(df.getIndicator2());
                List subfields = df.getSubfields();
                for (Subfield sf : subfields) {
                    data.write(31);
                    data.write(sf.getCode());
                    data.write(this.getDataElement(sf.getData()));
                }
                data.write(30);
                dir.write(this.getEntry(df.getTag(), data.size() - previous, previous));
                previous = data.size();
            }
            dir.write(30);
            Leader ldr = record.getLeader();
            ldr.setBaseAddressOfData(24 + dir.size());
            ldr.setRecordLength(ldr.getBaseAddressOfData() + data.size() + 1);
            dir.close();
            data.close();
            this.write(ldr);
            this.out.write(dir.toByteArray());
            this.out.write(data.toByteArray());
            this.out.write(29);
        }
        catch (IOException e) {
            throw new MarcException("IO Error occured while writing record", e);
        }
    }

    private void write(Leader ldr) throws IOException {
        this.out.write(format5.format(ldr.getRecordLength()).getBytes(this.encoding));
        this.out.write(ldr.getRecordStatus());
        this.out.write(ldr.getTypeOfRecord());
        this.out.write(new String(ldr.getImplDefined1()).getBytes(this.encoding));
        this.out.write(ldr.getCharCodingScheme());
        this.out.write(Integer.toString(ldr.getIndicatorCount()).getBytes(this.encoding));
        this.out.write(Integer.toString(ldr.getSubfieldCodeLength()).getBytes(this.encoding));
        this.out.write(format5.format(ldr.getBaseAddressOfData()).getBytes(this.encoding));
        this.out.write(new String(ldr.getImplDefined2()).getBytes(this.encoding));
        this.out.write(new String(ldr.getEntryMap()).getBytes(this.encoding));
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new MarcException("IO Error occured on close", e);
        }
    }

    private byte[] getDataElement(String data) throws IOException {
        if (this.converter != null) {
            return this.converter.convert(data).getBytes(this.encoding);
        }
        return data.getBytes(this.encoding);
    }

    private byte[] getEntry(String tag, int length, int start) throws IOException {
        return (String.valueOf(tag) + format4.format(length) + format5.format(start)).getBytes(this.encoding);
    }
}

