/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.converter.impl;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Vector;
import org.marc4j.ErrorHandler;
import org.marc4j.MarcException;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.CodeTable;
import org.marc4j.converter.impl.CodeTableInterface;

public class AnselToUnicode
extends CharConverter {
    protected CodeTableInterface ct;
    protected boolean loadedMultibyte = false;
    protected ErrorHandler errorList = null;

    public AnselToUnicode() {
        this.ct = this.loadGeneratedTable(false);
    }

    public AnselToUnicode(boolean loadMultibyte) {
        this.ct = this.loadGeneratedTable(loadMultibyte);
    }

    public AnselToUnicode(ErrorHandler errorList) {
        this.ct = this.loadGeneratedTable(false);
        this.errorList = errorList;
    }

    public AnselToUnicode(ErrorHandler errorList, boolean loadMultibyte) {
        this.ct = this.loadGeneratedTable(loadMultibyte);
        this.errorList = errorList;
    }

    private CodeTableInterface loadGeneratedTable(boolean loadMultibyte) {
        try {
            Class<?> generated = Class.forName("org.marc4j.converter.impl.CodeTableGenerated");
            Constructor<?> cons = generated.getConstructor(new Class[0]);
            Object ct = cons.newInstance(new Object[0]);
            this.loadedMultibyte = true;
            return (CodeTableInterface)ct;
        }
        catch (Exception e) {
            CodeTable ct = loadMultibyte ? new CodeTable(AnselToUnicode.class.getResourceAsStream("resources/codetables.xml")) : new CodeTable(AnselToUnicode.class.getResourceAsStream("resources/codetablesnocjk.xml"));
            this.loadedMultibyte = loadMultibyte;
            return ct;
        }
    }

    public AnselToUnicode(String pathname) {
        this.ct = new CodeTable(pathname);
        this.loadedMultibyte = true;
    }

    public AnselToUnicode(InputStream in) {
        this.ct = new CodeTable(in);
        this.loadedMultibyte = true;
    }

    private void loadMultibyte() {
        this.ct = new CodeTable(this.getClass().getResourceAsStream("resources/codetables.xml"));
    }

    private void checkMode(char[] data, CodeTracker cdt) {
        int extra = 0;
        int extra2 = 0;
        boolean extra3 = false;
        while (cdt.offset + extra + extra2 < data.length && AnselToUnicode.isEscape(data[cdt.offset])) {
            block0 : switch (data[cdt.offset + 1 + extra]) {
                case '(': 
                case ',': {
                    this.set_cdt(cdt, 0, data, 2 + extra, false);
                    break;
                }
                case ')': 
                case '-': {
                    this.set_cdt(cdt, 1, data, 2 + extra, false);
                    break;
                }
                case '$': {
                    if (!this.loadedMultibyte) {
                        this.loadMultibyte();
                        this.loadedMultibyte = true;
                    }
                    switch (data[cdt.offset + 2 + extra + extra2]) {
                        case ')': 
                        case '-': {
                            this.set_cdt(cdt, 1, data, 3 + extra + extra2, true);
                            break block0;
                        }
                        case ',': {
                            this.set_cdt(cdt, 0, data, 3 + extra + extra2, true);
                            break block0;
                        }
                        case '1': {
                            cdt.g0 = data[cdt.offset + 2 + extra + extra2];
                            cdt.offset += 3 + extra + extra2;
                            cdt.multibyte = true;
                            break block0;
                        }
                        case ' ': {
                            ++extra2;
                            break block0;
                        }
                    }
                    ++cdt.offset;
                    if (this.errorList != null) {
                        this.errorList.addError(2, "Unknown character set code found following escape character. Discarding escape character.");
                        break;
                    }
                    throw new MarcException("Unknown character set code found following escape character.");
                }
                case 'b': 
                case 'g': 
                case 'p': {
                    cdt.g0 = data[cdt.offset + 1 + extra];
                    cdt.offset += 2 + extra;
                    cdt.multibyte = false;
                    break;
                }
                case 's': {
                    cdt.g0 = 66;
                    cdt.offset += 2 + extra;
                    cdt.multibyte = false;
                    break;
                }
                case ' ': {
                    if (this.errorList == null) {
                        throw new MarcException("Extraneous space character found within MARC8 character set escape sequence");
                    }
                    ++extra;
                    break;
                }
                default: {
                    ++cdt.offset;
                    if (this.errorList != null) {
                        this.errorList.addError(2, "Unknown character set code found following escape character. Discarding escape character.");
                        break;
                    }
                    throw new MarcException("Unknown character set code found following escape character.");
                }
            }
        }
        if (this.errorList != null && (extra != 0 || extra2 != 0)) {
            this.errorList.addError(1, extra + extra2 + " extraneous space characters found within MARC8 character set escape sequence");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void set_cdt(CodeTracker cdt, int g0_or_g1, char[] data, int addnlOffset, boolean multibyte) {
        if (data[cdt.offset + addnlOffset] == '!' && data[cdt.offset + addnlOffset + 1] == 'E') {
            ++addnlOffset;
        } else if (data[cdt.offset + addnlOffset] == ' ') {
            if (this.errorList == null) {
                throw new MarcException("Extraneous space character found within MARC8 character set escape sequence");
            }
            this.errorList.addError(1, "Extraneous space character found within MARC8 character set escape sequence. Skipping over space.");
            ++addnlOffset;
        } else if ("(,)-$!".indexOf(data[cdt.offset + addnlOffset]) != -1) {
            if (this.errorList == null) {
                throw new MarcException("Extraneaous intermediate character found following escape character.");
            }
            this.errorList.addError(2, "Extraneaous intermediate character found following escape character. Discarding intermediate character.");
            ++addnlOffset;
        }
        if ("34BE1NQS2".indexOf(data[cdt.offset + addnlOffset]) == -1) {
            ++cdt.offset;
            cdt.multibyte = false;
            if (this.errorList == null) throw new MarcException("Unknown character set code found following escape character.");
            this.errorList.addError(2, "Unknown character set code found following escape character. Discarding escape character.");
            return;
        } else {
            if (g0_or_g1 == 0) {
                cdt.g0 = data[cdt.offset + addnlOffset];
            } else {
                cdt.g1 = data[cdt.offset + addnlOffset];
            }
            cdt.offset += 1 + addnlOffset;
            cdt.multibyte = multibyte;
        }
    }

    public String convert(char[] data) {
        StringBuffer sb = new StringBuffer();
        int len = data.length;
        CodeTracker cdt = new CodeTracker();
        cdt.g0 = 66;
        cdt.g1 = 69;
        cdt.multibyte = false;
        cdt.offset = 0;
        this.checkMode(data, cdt);
        Queue diacritics = new Queue();
        while (cdt.offset < data.length) {
            char c;
            if (this.ct.isCombining(data[cdt.offset], cdt.g0, cdt.g1) && AnselToUnicode.hasNext(cdt.offset, len)) {
                while (this.ct.isCombining(data[cdt.offset], cdt.g0, cdt.g1) && AnselToUnicode.hasNext(cdt.offset, len)) {
                    c = this.getChar(data[cdt.offset], cdt.g0, cdt.g1);
                    if (c != '\u0000') {
                        diacritics.put(new Character(c));
                    }
                    ++cdt.offset;
                    this.checkMode(data, cdt);
                }
                char c2 = this.getChar(data[cdt.offset], cdt.g0, cdt.g1);
                ++cdt.offset;
                this.checkMode(data, cdt);
                if (c2 != '\u0000') {
                    sb.append(c2);
                }
                while (!diacritics.isEmpty()) {
                    char c1 = ((Character)diacritics.get()).charValue();
                    sb.append(c1);
                }
            } else if (cdt.multibyte) {
                if (data[cdt.offset] == ' ') {
                    ++cdt.offset;
                } else if (cdt.offset + 3 <= data.length && (this.errorList == null || data[cdt.offset + 1] != ' ' && data[cdt.offset + 2] != ' ')) {
                    c = this.getMBChar(this.makeMultibyte(data[cdt.offset], data[cdt.offset + 1], data[cdt.offset + 2]));
                    if (this.errorList == null || c != '\u0000') {
                        sb.append(c);
                        cdt.offset += 3;
                    } else if (cdt.offset + 6 <= data.length && data[cdt.offset + 4] != ' ' && data[cdt.offset + 5] != ' ' && this.getMBChar(this.makeMultibyte(data[cdt.offset + 3], data[cdt.offset + 4], data[cdt.offset + 5])) != '\u0000') {
                        if (this.errorList != null) {
                            this.errorList.addError(2, "Erroneous MARC8 multibyte character, Discarding bad character and continuing reading Multibyte characters");
                            sb.append("[?]");
                            cdt.offset += 3;
                        }
                    } else if (cdt.offset + 4 <= data.length && data[cdt.offset] > '\u007f' && this.getMBChar(this.makeMultibyte(data[cdt.offset + 1], data[cdt.offset + 2], data[cdt.offset + 3])) != '\u0000') {
                        if (this.errorList != null) {
                            this.errorList.addError(2, "Erroneous character in MARC8 multibyte character, Copying bad character and continuing reading Multibyte characters");
                            sb.append(this.getChar(data[cdt.offset], 66, 69));
                            ++cdt.offset;
                        }
                    } else {
                        if (this.errorList != null) {
                            this.errorList.addError(2, "Erroneous MARC8 multibyte character, inserting change to default character set");
                        }
                        cdt.multibyte = false;
                        cdt.g0 = 66;
                        cdt.g1 = 69;
                    }
                } else if (this.errorList != null && cdt.offset + 4 <= data.length && (data[cdt.offset + 1] == ' ' || data[cdt.offset + 2] == ' ')) {
                    int multiByte = this.makeMultibyte(data[cdt.offset], data[cdt.offset + 1] != ' ' ? data[cdt.offset + 1] : data[cdt.offset + 2], data[cdt.offset + 3]);
                    char c2 = this.getMBChar(multiByte);
                    if (c2 != '\u0000') {
                        if (this.errorList != null) {
                            this.errorList.addError(1, "Extraneous space found within MARC8 multibyte character");
                        }
                        sb.append(c2);
                        sb.append(' ');
                        cdt.offset += 4;
                    } else {
                        if (this.errorList != null) {
                            this.errorList.addError(2, "Erroneous MARC8 multibyte character, inserting change to default character set");
                        }
                        cdt.multibyte = false;
                        cdt.g0 = 66;
                        cdt.g1 = 69;
                    }
                } else if (cdt.offset + 3 > data.length) {
                    if (this.errorList != null) {
                        this.errorList.addError(2, "Partial MARC8 multibyte character, inserting change to default character set");
                        cdt.multibyte = false;
                        cdt.g0 = 66;
                        cdt.g1 = 69;
                    } else {
                        cdt.offset += 3;
                    }
                }
            } else {
                c = this.getChar(data[cdt.offset], cdt.g0, cdt.g1);
                if (c != '\u0000') {
                    sb.append(c);
                } else {
                    String val = "0000" + Integer.toHexString(data[cdt.offset]);
                    sb.append("<U+" + val.substring(val.length() - 4, val.length()) + ">");
                }
                ++cdt.offset;
            }
            if (!AnselToUnicode.hasNext(cdt.offset, len)) continue;
            this.checkMode(data, cdt);
        }
        return sb.toString();
    }

    private int makeMultibyte(char[] data) {
        int[] chars = new int[]{data[0] << 16, data[1] << 8, data[2]};
        return chars[0] | chars[1] | chars[2];
    }

    public int makeMultibyte(char c1, char c2, char c3) {
        int[] chars = new int[]{c1 << 16, c2 << 8, c3};
        return chars[0] | chars[1] | chars[2];
    }

    private char getChar(int ch, int g0, int g1) {
        if (ch <= 126) {
            return this.ct.getChar(ch, g0);
        }
        return this.ct.getChar(ch, g1);
    }

    public char getMBChar(int ch) {
        return this.ct.getChar(ch, 49);
    }

    private static boolean hasNext(int pos, int len) {
        return pos < len - 1;
    }

    private static boolean isEscape(int i) {
        return i == 27;
    }

    class CodeTracker {
        int offset;
        int g0;
        int g1;
        boolean multibyte;

        CodeTracker() {
        }

        public String toString() {
            return "Offset: " + this.offset + " G0: " + Integer.toHexString(this.g0) + " G1: " + Integer.toHexString(this.g1) + " Multibyte: " + this.multibyte;
        }
    }

    class Queue
    extends Vector {
        Queue() {
        }

        public Object put(Object item) {
            this.addElement(item);
            return item;
        }

        public Object get() {
            int len = this.size();
            Object obj = this.peek();
            this.removeElementAt(0);
            return obj;
        }

        public Object peek() {
            int len = this.size();
            return this.elementAt(0);
        }

        public boolean empty() {
            return this.size() == 0;
        }
    }
}

