/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.AbstractTokenizedStringDistance;
import com.wcohen.ss.BagOfTokens;
import com.wcohen.ss.Levenstein;
import com.wcohen.ss.api.StringDistance;
import com.wcohen.ss.api.StringWrapper;
import com.wcohen.ss.api.StringWrapperIterator;
import com.wcohen.ss.api.Token;
import com.wcohen.ss.api.Tokenizer;
import com.wcohen.ss.tokens.SimpleTokenizer;
import java.util.Iterator;

public class Level2
extends AbstractTokenizedStringDistance {
    private Tokenizer tokenizer;
    private StringDistance tokenDistance;

    public Level2(Tokenizer tokenizer, StringDistance tokenDistance) {
        this.tokenizer = tokenizer;
        this.tokenDistance = tokenDistance;
    }

    @Override
    public double score(StringWrapper s, StringWrapper t) {
        BagOfTokens sBag = this.asBagOfTokens(s);
        BagOfTokens tBag = this.asBagOfTokens(t);
        double sumOverI = 0.0;
        Iterator<Token> i = sBag.tokenIterator();
        while (i.hasNext()) {
            Token tokenI = i.next();
            double maxOverJ = -1.7976931348623157E308;
            Iterator<Token> j = tBag.tokenIterator();
            while (j.hasNext()) {
                Token tokenJ = j.next();
                double scoreItoJ = this.tokenDistance.score(tokenI.getValue(), tokenJ.getValue());
                maxOverJ = Math.max(maxOverJ, scoreItoJ);
            }
            sumOverI += maxOverJ;
        }
        return sumOverI / (double)sBag.size();
    }

    @Override
    public String explainScore(StringWrapper s, StringWrapper t) {
        StringBuilder buf = new StringBuilder();
        BagOfTokens sBag = this.asBagOfTokens(s);
        BagOfTokens tBag = this.asBagOfTokens(t);
        double sumOverI = 0.0;
        Iterator<Token> i = sBag.tokenIterator();
        while (i.hasNext()) {
            Token tokenI = i.next();
            buf.append("token=" + tokenI);
            double maxOverJ = -1.7976931348623157E308;
            Token closestToI = null;
            Iterator<Token> j = tBag.tokenIterator();
            while (j.hasNext()) {
                Token tokenJ = j.next();
                double scoreItoJ = this.tokenDistance.score(tokenI.getValue(), tokenJ.getValue());
                buf.append(" dist(" + tokenJ.getValue() + ")=" + scoreItoJ);
                if (!(scoreItoJ >= maxOverJ)) continue;
                maxOverJ = scoreItoJ;
                closestToI = tokenJ;
            }
            sumOverI += maxOverJ;
            buf.append(" match=" + closestToI + " score=" + maxOverJ + "\n");
        }
        buf.append("total: " + sumOverI + "/" + sBag.size() + " = " + this.score(s, t) + "\n");
        return buf.toString();
    }

    @Override
    public void train(StringWrapperIterator i) {
    }

    public String toString() {
        return "[Level2:tokenizer=" + this.tokenizer + ";tokenDist=" + this.tokenDistance + "]";
    }

    public static void main(String[] argv) {
        Level2.doMain(new Level2(SimpleTokenizer.DEFAULT_TOKENIZER, new Levenstein()), argv);
    }
}

