/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss;

import com.wcohen.ss.JaroWinkler;
import com.wcohen.ss.MultiStringDistance;
import com.wcohen.ss.PrintfFormat;
import com.wcohen.ss.api.StringDistance;

public class MultiStringAvgDistance
extends MultiStringDistance {
    private StringDistance innerDistance;

    public MultiStringAvgDistance(StringDistance distance, String delim) {
        super(delim);
        this.innerDistance = distance;
    }

    @Override
    protected double scoreCombination(double[] multiScore) {
        double sum = 0.0;
        for (int i = 0; i < multiScore.length; ++i) {
            sum += multiScore[i];
        }
        return sum / (double)multiScore.length;
    }

    @Override
    protected String explainScoreCombination(double[] multiScore) {
        StringBuilder buf = new StringBuilder("");
        PrintfFormat fmt = new PrintfFormat(" %.3f");
        buf.append("field-level scores [");
        for (int i = 0; i < multiScore.length; ++i) {
            buf.append(fmt.sprintf(multiScore[i]));
        }
        buf.append("] Average score:");
        buf.append(fmt.sprintf(this.scoreCombination(multiScore)));
        return buf.toString();
    }

    @Override
    protected StringDistance getDistance(int i) {
        return this.innerDistance;
    }

    public static void main(String[] argv) {
        MultiStringAvgDistance.doMain(new MultiStringAvgDistance(new JaroWinkler(), ":"), argv);
    }
}

