/*
 * Decompiled with CFR 0.152.
 */
package com.wcohen.ss.expt;

import com.wcohen.ss.DistanceLearnerFactory;
import com.wcohen.ss.PrintfFormat;
import com.wcohen.ss.api.StringDistanceLearner;
import com.wcohen.ss.expt.Blocker;
import com.wcohen.ss.expt.MatchData;
import com.wcohen.ss.expt.MatchExpt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class MatchExptScript {
    public static final String BLOCKER_PACKAGE = "com.wcohen.ss.expt.";
    public static final String DISTANCE_PACKAGE = "com.wcohen.ss.";
    private List blockers = new ArrayList();
    private List datasets = new ArrayList();
    private List learners = new ArrayList();
    private List blockerNames = new ArrayList();
    private List datasetNames = new ArrayList();
    private List learnerNames = new ArrayList();
    private MatchExpt[][][] expt = null;
    private boolean echoCommands = true;
    private boolean computable = true;

    public void clear(String what) {
        if (what.equals("blockers")) {
            this.blockers.clear();
        } else if (what.equals("datasets")) {
            this.datasets.clear();
        } else if (what.equals("learners")) {
            this.learners.clear();
        } else if (what.equals("all")) {
            this.clear("blockers");
            this.clear("datasets");
            this.clear("learners");
        } else {
            System.out.println("usage: clear blockers|datasets|learners|all");
        }
    }

    public void show(String what) {
        if (what.equals("blockers")) {
            MatchExptScript.showList("blockers", this.blockerNames);
        } else if (what.equals("datasets")) {
            MatchExptScript.showList("datasets", this.datasetNames);
        } else if (what.equals("learners")) {
            MatchExptScript.showList("learners", this.learnerNames);
        } else if (what.equals("all")) {
            this.show("blockers");
            this.show("datasets");
            this.show("learners");
        } else {
            System.out.println("usage: show blockers|datasets|learners|all");
        }
    }

    private static void showList(String s, List list) {
        System.out.println(list.size() + " " + s + ":");
        for (int i = 0; i < list.size(); ++i) {
            System.out.println(i + 1 + ". " + list.get(i).toString());
        }
    }

    public void echo(String onOrOff) {
        this.echoCommands = "on".equals(onOrOff);
    }

    public void dataset(String dataFile) throws MatchData.InputFormatException {
        this.datasets.add(new MatchData(dataFile));
        this.datasetNames.add(dataFile);
        this.expt = null;
    }

    public void learner(String learnerClass) {
        this.learners.add(DistanceLearnerFactory.build(learnerClass));
        this.learnerNames.add(learnerClass);
        this.expt = null;
    }

    public void distance(String distanceClass) {
        this.learner(distanceClass);
    }

    public void blocker(String blockerClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.blockers.add(Class.forName(BLOCKER_PACKAGE + blockerClass).newInstance());
        this.blockerNames.add(blockerClass);
        this.expt = null;
    }

    public void blocker(String blockerClass, String param, String value) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Blocker blocker = (Blocker)Class.forName(BLOCKER_PACKAGE + blockerClass).newInstance();
        param = param.substring(0, 1).toUpperCase() + param.substring(1, param.length());
        Method m = blocker.getClass().getMethod("set" + param, Boolean.class);
        m.invoke((Object)blocker, Boolean.valueOf(value));
        this.blockers.add(blocker);
        this.blockerNames.add(blockerClass);
        this.expt = null;
    }

    public void compute() {
        if (!this.computable) {
            throw new RuntimeException("can't re-'compute' experiment results after a 'restore'");
        }
        this.expt = new MatchExpt[this.blockers.size()][this.learners.size()][this.datasets.size()];
        for (int i = 0; i < this.blockers.size(); ++i) {
            Blocker blocker = (Blocker)this.blockers.get(i);
            for (int j = 0; j < this.learners.size(); ++j) {
                StringDistanceLearner distance = (StringDistanceLearner)this.learners.get(j);
                for (int k = 0; k < this.datasets.size(); ++k) {
                    MatchData dataset = (MatchData)this.datasets.get(k);
                    this.expt[i][j][k] = new MatchExpt(dataset, distance, blocker);
                }
            }
        }
    }

    public void table(String what) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        PrintfFormat dfmt = new PrintfFormat("Dataset %2d:");
        PrintfFormat fmt = new PrintfFormat(" %9.5f  ");
        PrintfFormat nfmt = new PrintfFormat(" %11s");
        if (this.expt == null) {
            this.compute();
        }
        for (int i = 0; i < this.blockerNames.size(); ++i) {
            System.out.println("\nblocker: " + this.blockerNames.get(i) + "\n");
            System.out.print("           ");
            for (int j = 0; j < this.learnerNames.size(); ++j) {
                String s = (String)this.learnerNames.get(j);
                if (s.length() > 11) {
                    s = s.substring(0, 11);
                }
                System.out.print(nfmt.sprintf(s));
            }
            System.out.println();
            double[] average = new double[this.learnerNames.size()];
            for (int k = 0; k < this.datasetNames.size(); ++k) {
                System.out.print(dfmt.sprintf(k + 1));
                int j = 0;
                while (j < this.learnerNames.size()) {
                    Method m = MatchExpt.class.getMethod(what, new Class[0]);
                    Double d = (Double)m.invoke((Object)this.expt[i][j][k], new Object[0]);
                    System.out.print(fmt.sprintf(d));
                    int n = j++;
                    average[n] = average[n] + d;
                }
                System.out.print("\n");
            }
            System.out.print("   Average:");
            for (int j = 0; j < this.learnerNames.size(); ++j) {
                System.out.print(fmt.sprintf(average[j] / (double)this.datasetNames.size()));
            }
            System.out.print("\n\n");
        }
    }

    public void precisionRecall() {
        PrintfFormat fmt1 = new PrintfFormat("%9s %9s %9s");
        PrintfFormat fmt2 = new PrintfFormat(" %5.2f");
        PrintfFormat hfmt2 = new PrintfFormat(" r%4.2f");
        System.out.print(fmt1.sprintf(new Object[]{"block", "dist", "data"}));
        double[] rec = MatchExpt.interpolated11PointRecallLevels();
        for (int m = 0; m < rec.length; ++m) {
            System.out.print(hfmt2.sprintf(rec[m]));
        }
        System.out.println("   avgPrec\n");
        for (int i = 0; i < this.blockerNames.size(); ++i) {
            String blocker = (String)this.blockerNames.get(i);
            if (blocker.length() > 7) {
                blocker = blocker.substring(0, 7);
            }
            for (int j = 0; j < this.learnerNames.size(); ++j) {
                String distance = (String)this.learnerNames.get(j);
                if (distance.length() > 7) {
                    distance = distance.substring(0, 7);
                }
                double[] average = new double[12];
                for (int k = 0; k < this.datasetNames.size(); ++k) {
                    String dataset = (String)this.datasetNames.get(k);
                    int dotPos = (dataset = new File(dataset).getName()).indexOf(46);
                    if (dotPos >= 0) {
                        dataset = dataset.substring(0, dotPos);
                    }
                    if (dataset.length() > 9) {
                        dataset = dataset.substring(0, 9);
                    }
                    System.out.print(fmt1.sprintf(new Object[]{blocker, distance, dataset}));
                    double[] prec = this.expt[i][j][k].interpolated11PointPrecision();
                    for (int m = 0; m < prec.length; ++m) {
                        System.out.print(fmt2.sprintf(prec[m]));
                        int n = m;
                        average[n] = average[n] + prec[m];
                    }
                    double a = this.expt[i][j][k].averagePrecision();
                    System.out.print("   " + fmt2.sprintf(a));
                    average[11] = average[11] + a;
                    System.out.print("\n");
                }
                System.out.print(fmt1.sprintf(new Object[]{blocker, distance, "avg"}));
                for (int m = 0; m < average.length - 1; ++m) {
                    System.out.print(fmt2.sprintf(average[m] / (double)this.datasetNames.size()));
                }
                System.out.println("   " + fmt2.sprintf(average[11] / (double)this.datasetNames.size()) + "\n");
            }
        }
    }

    public void save(String file) throws IOException, FileNotFoundException {
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
        oos.writeObject(this.blockerNames);
        oos.writeObject(this.datasetNames);
        oos.writeObject(this.learnerNames);
        oos.writeObject(this.expt);
        oos.close();
    }

    public void restore(String file) throws IOException, FileNotFoundException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
        this.blockerNames = (List)ois.readObject();
        this.datasetNames = (List)ois.readObject();
        this.learnerNames = (List)ois.readObject();
        this.expt = (MatchExpt[][][])ois.readObject();
        this.computable = false;
        ois.close();
    }

    public void runScript(String configFileName) {
        int lineNum = 0;
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(configFileName));
            while ((line = in.readLine()) != null) {
                ++lineNum;
                if (line.startsWith("#")) continue;
                String command = null;
                ArrayList<String> args = new ArrayList<String>();
                StringTokenizer tok = new StringTokenizer(line);
                if (tok.hasMoreTokens()) {
                    command = tok.nextToken();
                }
                while (tok.hasMoreTokens()) {
                    args.add(tok.nextToken());
                }
                if (command == null) continue;
                if (this.echoCommands) {
                    System.out.println("exec: " + line);
                }
                this.execCommand(command, args);
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + configFileName + " line " + lineNum + ": " + e.toString());
            e.printStackTrace();
            return;
        }
    }

    private void execCommand(String command, List args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] template = new Class[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            template[i] = String.class;
        }
        Method m = MatchExptScript.class.getMethod(command, template);
        m.invoke((Object)this, (Object[])args.toArray(new String[args.size()]));
    }

    public static void main(String[] argv) {
        try {
            MatchExptScript interp = new MatchExptScript();
            if (argv.length == 0) {
                System.out.println("usage: file1 file2 ...");
            } else {
                for (int i = 0; i < argv.length; ++i) {
                    interp.runScript(argv[i]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

