/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.vicino;

import edu.mit.simile.vicino.Operator;
import edu.mit.simile.vicino.distances.Distance;
import edu.mit.simile.vicino.vptree.VPTree;
import edu.mit.simile.vicino.vptree.VPTreeBuilder;
import edu.mit.simile.vicino.vptree.VPTreeSeeker;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Seeker
extends Operator {
    public static void main(String[] args) throws Exception {
        Distance d = Seeker.getDistance(args[0]);
        Seeker.log("Working with distance: " + d);
        List<String> strings = Seeker.getStrings(args[1]);
        Seeker.log("Obtained " + strings.size() + " from " + args[1]);
        Seeker.log("Building VPTree...");
        VPTreeBuilder builder = new VPTreeBuilder(d);
        VPTree tree = builder.buildVPTree(strings);
        Seeker.log("..done");
        VPTreeSeeker seeker = new VPTreeSeeker(d, tree);
        Seeker.log("type a string|range then hit return:");
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        String line = null;
        while ((line = input.readLine()) != null) {
            int index = line.indexOf(124);
            String query = line.substring(0, index);
            float range = Float.parseFloat(line.substring(index + 1));
            long start = System.currentTimeMillis();
            Set<Serializable> results = seeker.range((Serializable)((Object)query), range);
            long stop = System.currentTimeMillis();
            Iterator<Serializable> j = results.iterator();
            if (j.hasNext()) {
                while (j.hasNext()) {
                    String r = (String)((Object)j.next());
                    Seeker.log("   " + r);
                }
                Seeker.log(" [done in " + (stop - start) + "ms]");
                continue;
            }
            Seeker.log(" [no results found in " + (stop - start) + "ms]");
        }
    }
}

