/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.vicino.vptree;

import edu.mit.simile.vicino.vptree.Node;

public class NodeSorter {
    public void sort(Node[] nodes) {
        NodeSorter.sort(nodes, 0, nodes.length - 1);
    }

    public static void sort(Node[] nodes, int lo, int hi) {
        int right;
        int left;
        Node tmp;
        if (lo >= hi) {
            return;
        }
        int mid = (lo + hi) / 2;
        if (nodes[lo].getDistance() > nodes[mid].getDistance()) {
            tmp = nodes[lo];
            nodes[lo] = nodes[mid];
            nodes[mid] = tmp;
        }
        if (nodes[mid].getDistance() > nodes[hi].getDistance()) {
            tmp = nodes[mid];
            nodes[mid] = nodes[hi];
            nodes[hi] = tmp;
            if (nodes[lo].getDistance() > nodes[mid].getDistance()) {
                Node tmp2 = nodes[lo];
                nodes[lo] = nodes[mid];
                nodes[mid] = tmp2;
            }
        }
        if ((left = lo + 1) >= (right = hi - 1)) {
            return;
        }
        Node partition = nodes[mid];
        while (true) {
            if (nodes[right].getDistance() > partition.getDistance()) {
                --right;
                continue;
            }
            while (left < right && nodes[left].getDistance() <= partition.getDistance()) {
                ++left;
            }
            if (left >= right) break;
            Node tmp2 = nodes[left];
            nodes[left] = nodes[right];
            nodes[right] = tmp2;
            --right;
        }
        NodeSorter.sort(nodes, lo, left);
        NodeSorter.sort(nodes, left + 1, hi);
    }
}

