/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.simile.vicino.vptree;

import edu.mit.simile.vicino.distances.Distance;
import edu.mit.simile.vicino.vptree.Node;
import edu.mit.simile.vicino.vptree.NodeSorter;
import edu.mit.simile.vicino.vptree.TNode;
import edu.mit.simile.vicino.vptree.VPTree;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class VPTreeBuilder {
    private static final boolean DEBUG = false;
    private static final boolean OPTIMIZED = false;
    private static final int sample_size = 10;
    private Random generator = new Random(System.currentTimeMillis());
    private final Distance distance;
    private Set<Node> nodes = new HashSet<Node>();

    public VPTreeBuilder(Distance distance) {
        this.distance = distance;
    }

    public Set<Node> getNodes() {
        return this.nodes;
    }

    public void populate(Serializable s) {
        this.nodes.add(new Node(s));
    }

    public VPTree buildVPTree() {
        Node[] nodes_array = this.nodes.toArray(new Node[this.nodes.size()]);
        VPTree tree = new VPTree();
        if (nodes_array.length > 0) {
            tree.setRoot(this.makeNode(nodes_array, 0, nodes_array.length - 1));
        }
        return tree;
    }

    public VPTree buildVPTree(Collection<? extends Serializable> values) {
        this.reset();
        for (Serializable serializable : values) {
            this.populate(serializable);
        }
        return this.buildVPTree();
    }

    public void reset() {
        this.nodes.clear();
    }

    private TNode makeNode(Node[] nodes, int begin, int end) {
        int delta = end - begin;
        if (delta == 0) {
            TNode vpNode = new TNode(nodes[begin].get());
            vpNode.setMedian(0.0);
            return vpNode;
        }
        if (delta < 0) {
            return null;
        }
        Node randomNode = this.getVantagePoint(nodes, begin, end);
        TNode vpNode = new TNode(randomNode.get());
        this.calculateDistances(vpNode, nodes, begin, end);
        this.orderDistances(nodes, begin, end);
        this.fixVantagPoint(randomNode, nodes, begin, end);
        float median = (float)this.median(nodes, begin, end);
        vpNode.setMedian(median);
        int i = 0;
        for (i = begin + 1; i < end; ++i) {
            if (!(nodes[i].getDistance() >= (double)median)) continue;
            vpNode.setLeft(this.makeNode(nodes, begin + 1, i - 1));
            break;
        }
        vpNode.setRight(this.makeNode(nodes, i, end));
        return vpNode;
    }

    private Node getVantagePoint(Node[] nodes, int begin, int end) {
        return this.getRandomNode(nodes, begin, end);
    }

    private Node getRandomNode(Node[] nodes, int begin, int end) {
        return nodes[begin + this.generator.nextInt(end - begin)];
    }

    private double deviation(Node[] buffer, double median) {
        double sum = 0.0;
        for (int i = 0; i < buffer.length; ++i) {
            sum += Math.pow(buffer[i].getDistance() - median, 2.0);
        }
        return sum / (double)buffer.length;
    }

    public double median(Node[] nodes, int begin, int end) {
        int delta = end - begin;
        int middle = delta / 2;
        if (delta % 2 == 0) {
            return nodes[begin + middle].getDistance();
        }
        return (nodes[begin + middle].getDistance() + nodes[begin + middle + 1].getDistance()) / 2.0;
    }

    private void calculateDistances(TNode pivot, Node[] nodes, int begin, int end) {
        Serializable x = pivot.get();
        for (int i = begin; i <= end; ++i) {
            Serializable y = nodes[i].get();
            double d = x == y || x.equals(y) ? 0.0 : this.distance.d(x.toString(), y.toString());
            nodes[i].setDistance(d);
        }
    }

    private void fixVantagPoint(Node pivot, Node[] nodes, int begin, int end) {
        for (int i = begin; i < end; ++i) {
            if (nodes[i] != pivot || i <= begin) continue;
            Node tmp = nodes[begin];
            nodes[begin] = pivot;
            nodes[i] = tmp;
            break;
        }
    }

    private void orderDistances(Node[] nodes, int begin, int end) {
        NodeSorter.sort(nodes, begin, end);
    }
}

