/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.openrewrite.Change;
import org.openrewrite.RefactorPlan;
import org.openrewrite.SourceVisitor;
import org.openrewrite.config.ProfileConfigurationLoader;
import org.openrewrite.config.SourceVisitorLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;
import org.openrewrite.maven.MavenProfileConfiguration;
import org.openrewrite.maven.MeterRegistryProvider;

public abstract class AbstractRewriteMojo
extends AbstractMojo {
    @Parameter(property="configLocation", defaultValue="rewrite.yml")
    String configLocation;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="activeProfiles", defaultValue="default")
    Set<String> activeProfiles;
    @Parameter(property="excludes")
    Set<String> excludes;
    @Parameter(property="metricsUri")
    private String metricsUri;
    @Parameter(property="metricsUsername")
    private String metricsUsername;
    @Parameter(property="metricsPassword")
    private String metricsPassword;
    @Parameter(property="profiles")
    private List<MavenProfileConfiguration> profiles;

    protected RefactorPlan plan() throws MojoExecutionException {
        File rewriteConfig;
        RefactorPlan.Builder plan = RefactorPlan.builder().compileClasspath((Iterable)this.project.getArtifacts().stream().map(d -> d.getFile().toPath()).collect(Collectors.toList())).scanResources().scanUserHome();
        if (this.profiles != null) {
            this.profiles.forEach(profile -> plan.loadProfile(profile.toProfileConfiguration()));
        }
        if ((rewriteConfig = new File(this.project.getBasedir() + "/" + this.configLocation)).exists()) {
            try (FileInputStream is = new FileInputStream(rewriteConfig);){
                YamlResourceLoader resourceLoader = new YamlResourceLoader((InputStream)is);
                plan.loadProfiles((ProfileConfigurationLoader)resourceLoader);
                plan.loadVisitors((SourceVisitorLoader)resourceLoader);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to load rewrite configuration", (Exception)e);
            }
        }
        return plan.build();
    }

    protected List<Change<J.CompilationUnit>> listChanges() throws MojoExecutionException {
        try (MeterRegistryProvider meterRegistryProvider = new MeterRegistryProvider(this.getLog(), this.metricsUri, this.metricsUsername, this.metricsPassword);){
            JavaParser.Builder javaParser;
            MeterRegistry meterRegistry = meterRegistryProvider.registry();
            RefactorPlan plan = this.plan();
            Collection javaVisitors = plan.visitors(J.class, this.activeProfiles);
            plan.configure((SourceVisitor)AddImport.orderImports, new String[]{"default"});
            List dependencies = this.project.getArtifacts().stream().map(d -> d.getFile().toPath()).collect(Collectors.toList());
            ArrayList<Path> sources = new ArrayList<Path>();
            sources.addAll(this.listJavaSources(this.project.getBuild().getSourceDirectory()));
            sources.addAll(this.listJavaSources(this.project.getBuild().getTestSourceDirectory()));
            try {
                javaParser = System.getProperty("java.version").startsWith("1.8") ? (JavaParser.Builder)Class.forName("org.openrewrite.java.Java8Parser").getDeclaredMethod("builder", new Class[0]).invoke(null, new Object[0]) : (JavaParser.Builder)Class.forName("org.openrewrite.java.Java11Parser").getDeclaredMethod("builder", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to create a Java parser instance. `rewrite-java-8` or `rewrite-java-11` must be on the classpath.");
            }
            List cus = javaParser.classpath(dependencies).logCompilationWarningsAndErrors(false).meterRegistry(meterRegistry).build().parse(sources, this.project.getBasedir().toPath());
            List<Change<J.CompilationUnit>> list = cus.stream().map(cu -> cu.refactor().visit((Iterable)javaVisitors).setMeterRegistry(meterRegistry).fix()).filter(change -> !change.getRulesThatMadeChanges().isEmpty()).collect(Collectors.toList());
            return list;
        }
    }

    private List<Path> listJavaSources(String sourceDirectory) throws MojoExecutionException {
        File sourceDirectoryFile = new File(sourceDirectory);
        if (!sourceDirectoryFile.exists()) {
            return Collections.emptyList();
        }
        Path sourceRoot = sourceDirectoryFile.toPath();
        try {
            return Files.walk(sourceRoot, new FileVisitOption[0]).filter(f -> !Files.isDirectory(f, new LinkOption[0]) && f.toFile().getName().endsWith(".java")).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to list Java source files", (Exception)e);
        }
    }
}

