/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.repository.RemoteRepository;
import org.openrewrite.Change;
import org.openrewrite.Refactor;
import org.openrewrite.RefactorPlan;
import org.openrewrite.config.ProfileConfigurationLoader;
import org.openrewrite.config.RefactorVisitorLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.java.JavaParser;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.MavenProfileConfiguration;
import org.openrewrite.maven.MeterRegistryProvider;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.yaml.YamlParser;

public abstract class AbstractRewriteMojo
extends AbstractMojo {
    @Parameter(property="configLocation", defaultValue="rewrite.yml")
    String configLocation;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="activeProfiles", defaultValue="default")
    String activeProfiles;
    @Parameter(property="metricsUri")
    private String metricsUri;
    @Parameter(property="metricsUsername")
    private String metricsUsername;
    @Parameter(property="metricsPassword")
    private String metricsPassword;
    @Parameter(property="profiles")
    private List<MavenProfileConfiguration> profiles;

    protected RefactorPlan plan() throws MojoExecutionException {
        File rewriteConfig;
        RefactorPlan.Builder plan = RefactorPlan.builder().compileClasspath((Iterable)this.project.getArtifacts().stream().map(d -> d.getFile().toPath()).collect(Collectors.toList())).scanResources().scanUserHome();
        if (this.profiles != null) {
            this.profiles.forEach(profile -> plan.loadProfile(profile.toProfileConfiguration()));
        }
        if ((rewriteConfig = new File(this.project.getBasedir() + "/" + this.configLocation)).exists()) {
            try (FileInputStream is = new FileInputStream(rewriteConfig);){
                YamlResourceLoader resourceLoader = new YamlResourceLoader((InputStream)is);
                plan.loadProfiles((ProfileConfigurationLoader)resourceLoader);
                plan.loadVisitors((RefactorVisitorLoader)resourceLoader);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to load rewrite configuration", (Exception)e);
            }
        }
        return plan.build();
    }

    protected Collection<Change> listChanges() throws MojoExecutionException {
        try (MeterRegistryProvider meterRegistryProvider = new MeterRegistryProvider(this.getLog(), this.metricsUri, this.metricsUsername, this.metricsPassword);){
            MeterRegistry meterRegistry = meterRegistryProvider.registry();
            RefactorPlan plan = this.plan();
            Collection visitors = plan.visitors((String[])Arrays.stream(this.activeProfiles.split(",")).map(String::trim).toArray(String[]::new));
            ArrayList sourceFiles = new ArrayList();
            ArrayList<Path> javaSources = new ArrayList<Path>();
            javaSources.addAll(this.listJavaSources(this.project.getBuild().getSourceDirectory()));
            javaSources.addAll(this.listJavaSources(this.project.getBuild().getTestSourceDirectory()));
            sourceFiles.addAll(JavaParser.fromJavaVersion().classpath(this.project.getArtifacts().stream().map(d -> d.getFile().toPath()).collect(Collectors.toList())).logCompilationWarningsAndErrors(false).meterRegistry(meterRegistry).build().parse(javaSources, this.project.getBasedir().toPath()));
            sourceFiles.addAll(new YamlParser().parse(Stream.concat(this.project.getBuild().getResources().stream(), this.project.getBuild().getTestResources().stream()).map(Resource::getTargetPath).filter(Objects::nonNull).filter(it -> it.endsWith(".yml") || it.endsWith(".yaml")).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList()), this.project.getBasedir().toPath()));
            sourceFiles.addAll(new PropertiesParser().parse(Stream.concat(this.project.getBuild().getResources().stream(), this.project.getBuild().getTestResources().stream()).map(Resource::getTargetPath).filter(Objects::nonNull).filter(it -> it.endsWith(".properties")).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList()), this.project.getBasedir().toPath()));
            File localRepo = new File(new File(this.project.getBuild().getOutputDirectory(), "rewrite"), ".m2");
            if (localRepo.mkdirs()) {
                sourceFiles.addAll(MavenParser.builder().localRepository(localRepo).remoteRepositories(this.project.getRepositories().stream().map(repo -> new RemoteRepository.Builder("central", "default", "https://repo1.maven.org/maven2/").build()).collect(Collectors.toList())).build().parse(Collections.singletonList(this.project.getFile().toPath()), this.project.getBasedir().toPath()));
            }
            Collection collection = new Refactor().visit((Iterable)visitors).fix(sourceFiles);
            return collection;
        }
    }

    private List<Path> listJavaSources(String sourceDirectory) throws MojoExecutionException {
        File sourceDirectoryFile = new File(sourceDirectory);
        if (!sourceDirectoryFile.exists()) {
            return Collections.emptyList();
        }
        Path sourceRoot = sourceDirectoryFile.toPath();
        try {
            return Files.walk(sourceRoot, new FileVisitOption[0]).filter(f -> !Files.isDirectory(f, new LinkOption[0]) && f.toFile().getName().endsWith(".java")).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to list Java source files", (Exception)e);
        }
    }
}

