/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.openrewrite.Change;
import org.openrewrite.Environment;
import org.openrewrite.Refactor;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.java.JavaParser;
import org.openrewrite.maven.MeterRegistryProvider;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.yaml.YamlParser;

public abstract class AbstractRewriteMojo
extends AbstractMojo {
    @Parameter(property="configLocation", defaultValue="${maven.multiModuleProjectDirectory}/rewrite.yml")
    String configLocation;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="activeRecipes")
    protected Set<String> activeRecipes;
    @Parameter(property="activeStyles")
    Set<String> activeStyles;
    @Parameter(property="metricsUri")
    private String metricsUri;
    @Parameter(property="metricsUsername")
    private String metricsUsername;
    @Parameter(property="metricsPassword")
    private String metricsPassword;

    protected Environment environment() throws MojoExecutionException {
        Environment.Builder env;
        block16: {
            File rewriteConfig;
            env = Environment.builder((Properties)this.project.getProperties()).scanClasspath((Iterable)this.project.getArtifacts().stream().map(d -> d.getFile().toPath()).collect(Collectors.toList()), new String[0]).scanUserHome();
            Path absoluteConfigLocation = Paths.get(this.configLocation, new String[0]);
            if (!absoluteConfigLocation.isAbsolute()) {
                absoluteConfigLocation = this.project.getBasedir().toPath().resolve(this.configLocation);
            }
            if ((rewriteConfig = absoluteConfigLocation.toFile()).exists()) {
                try (FileInputStream is = new FileInputStream(rewriteConfig);){
                    env.load((ResourceLoader)new YamlResourceLoader((InputStream)is, rewriteConfig.toURI(), this.project.getProperties()));
                    break block16;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to load rewrite configuration", (Exception)e);
                }
            }
            throw new MojoExecutionException("Unable to load rewrite configuration, because it does not exist: " + rewriteConfig.toString());
        }
        return env.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ChangesContainer listChanges() throws MojoExecutionException {
        try (MeterRegistryProvider meterRegistryProvider = new MeterRegistryProvider(this.getLog(), this.metricsUri, this.metricsUsername, this.metricsPassword);){
            MeterRegistry meterRegistry = meterRegistryProvider.registry();
            if (this.activeRecipes == null || this.activeRecipes.isEmpty()) {
                ChangesContainer changesContainer = new ChangesContainer(Collections.emptyList());
                return changesContainer;
            }
            Environment env = this.environment();
            Collection visitors = env.visitors(this.activeRecipes);
            ArrayList sourceFiles = new ArrayList();
            ArrayList<Path> javaSources = new ArrayList<Path>();
            javaSources.addAll(this.listJavaSources(this.project.getBuild().getSourceDirectory()));
            javaSources.addAll(this.listJavaSources(this.project.getBuild().getTestSourceDirectory()));
            sourceFiles.addAll(JavaParser.fromJavaVersion().styles((Iterable)env.styles(this.activeStyles)).classpath((Collection)Stream.concat(this.project.getCompileClasspathElements().stream(), this.project.getTestClasspathElements().stream()).distinct().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList())).logCompilationWarningsAndErrors(false).meterRegistry(meterRegistry).build().parse(javaSources, this.project.getBasedir().toPath()));
            sourceFiles.addAll(new YamlParser().parse((Iterable)Stream.concat(this.project.getBuild().getResources().stream(), this.project.getBuild().getTestResources().stream()).map(Resource::getTargetPath).filter(Objects::nonNull).filter(it -> it.endsWith(".yml") || it.endsWith(".yaml")).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList()), this.project.getBasedir().toPath()));
            sourceFiles.addAll(new PropertiesParser().parse((Iterable)Stream.concat(this.project.getBuild().getResources().stream(), this.project.getBuild().getTestResources().stream()).map(Resource::getTargetPath).filter(Objects::nonNull).filter(it -> it.endsWith(".properties")).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList()), this.project.getBasedir().toPath()));
            ArrayList<Path> allPoms = new ArrayList<Path>();
            allPoms.add(this.project.getFile().toPath());
            if (this.project.getCollectedProjects() != null) {
                this.project.getCollectedProjects().stream().filter(collectedProject -> collectedProject != this.project).map(collectedProject -> collectedProject.getFile().toPath()).forEach(allPoms::add);
            }
            for (MavenProject parent = this.project.getParent(); parent != null && parent.getFile() != null; parent = parent.getParent()) {
                allPoms.add(parent.getFile().toPath());
            }
            Collection changes = new Refactor().visit((Iterable)visitors).setMeterRegistry(meterRegistry).fix(sourceFiles);
            ChangesContainer changesContainer = new ChangesContainer(changes);
            return changesContainer;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Dependency resolution required", (Exception)((Object)e));
        }
    }

    protected List<Path> listJavaSources(String sourceDirectory) throws MojoExecutionException {
        File sourceDirectoryFile = new File(sourceDirectory);
        if (!sourceDirectoryFile.exists()) {
            return Collections.emptyList();
        }
        Path sourceRoot = sourceDirectoryFile.toPath();
        try {
            return Files.walk(sourceRoot, new FileVisitOption[0]).filter(f -> !Files.isDirectory(f, new LinkOption[0]) && f.toFile().getName().endsWith(".java")).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to list Java source files", (Exception)e);
        }
    }

    protected void logVisitorsThatMadeChanges(Change change) {
        for (String visitor : change.getVisitorsThatMadeChanges()) {
            this.getLog().warn((CharSequence)("  " + visitor));
        }
    }

    public static class ChangesContainer {
        final List<Change> generated = new ArrayList<Change>();
        final List<Change> deleted = new ArrayList<Change>();
        final List<Change> moved = new ArrayList<Change>();
        final List<Change> refactoredInPlace = new ArrayList<Change>();

        public ChangesContainer(Collection<Change> changes) {
            for (Change change : changes) {
                if (change.getOriginal() == null && change.getFixed() == null) continue;
                if (change.getOriginal() == null && change.getFixed() != null) {
                    this.generated.add(change);
                    continue;
                }
                if (change.getOriginal() != null && change.getFixed() == null) {
                    this.deleted.add(change);
                    continue;
                }
                if (change.getOriginal() != null && !change.getOriginal().getSourcePath().equals(change.getFixed().getSourcePath())) {
                    this.moved.add(change);
                    continue;
                }
                this.refactoredInPlace.add(change);
            }
        }

        public boolean isNotEmpty() {
            return !this.generated.isEmpty() || !this.deleted.isEmpty() || !this.moved.isEmpty() || !this.refactoredInPlace.isEmpty();
        }

        public Stream<Change> stream() {
            return Stream.concat(Stream.concat(this.generated.stream(), this.deleted.stream()), Stream.concat(this.moved.stream(), this.refactoredInPlace.stream()));
        }
    }
}

