/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.openrewrite.Change;
import org.openrewrite.maven.AbstractRewriteMojo;

@Mojo(name="fix", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
@Execute(phase=LifecyclePhase.PROCESS_TEST_CLASSES)
public class RewriteFixMojo
extends AbstractRewriteMojo {
    public void execute() throws MojoExecutionException {
        AbstractRewriteMojo.ChangesContainer changes = this.listChanges();
        if (changes.isNotEmpty()) {
            for (Change change : changes.generated) {
                this.getLog().warn((CharSequence)("Generated new file " + change.getFixed().getSourcePath() + " by:"));
                this.logVisitorsThatMadeChanges(change);
            }
            for (Change change : changes.deleted) {
                this.getLog().warn((CharSequence)("Deleted file " + change.getOriginal().getSourcePath() + " by:"));
                this.logVisitorsThatMadeChanges(change);
            }
            for (Change change : changes.moved) {
                this.getLog().warn((CharSequence)("File has been moved from " + change.getOriginal().getSourcePath() + " to " + change.getFixed().getSourcePath() + " by:"));
                this.logVisitorsThatMadeChanges(change);
            }
            for (Change change : changes.refactoredInPlace) {
                this.getLog().warn((CharSequence)("Changes have been made to " + change.getOriginal().getSourcePath() + " by:"));
                this.logVisitorsThatMadeChanges(change);
            }
            this.getLog().warn((CharSequence)"Please review and commit the changes.");
            try {
                Path originalLocation;
                BufferedWriter sourceFileWriter;
                for (Change change : changes.generated) {
                    sourceFileWriter = Files.newBufferedWriter(this.project.getBasedir().toPath().resolve(Paths.get(change.getFixed().getSourcePath(), new String[0])), new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        sourceFileWriter.write(change.getFixed().print());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (sourceFileWriter == null) continue;
                        if (throwable != null) {
                            try {
                                sourceFileWriter.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        sourceFileWriter.close();
                    }
                }
                for (Change change : changes.deleted) {
                    originalLocation = this.project.getBasedir().toPath().resolve(Paths.get(change.getOriginal().getSourcePath(), new String[0]));
                    boolean deleteSucceeded = originalLocation.toFile().delete();
                    if (deleteSucceeded) continue;
                    throw new IOException("Unable to delete file " + originalLocation.toAbsolutePath());
                }
                for (Change change : changes.moved) {
                    originalLocation = this.project.getBasedir().toPath().resolve(Paths.get(change.getOriginal().getSourcePath(), new String[0]));
                    boolean deleteSucceeded = originalLocation.toFile().delete();
                    if (!deleteSucceeded) {
                        throw new IOException("Unable to delete file " + originalLocation.toAbsolutePath());
                    }
                    BufferedWriter sourceFileWriter2 = Files.newBufferedWriter(this.project.getBasedir().toPath().resolve(Paths.get(change.getFixed().getSourcePath(), new String[0])), new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        sourceFileWriter2.write(change.getFixed().print());
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (sourceFileWriter2 == null) continue;
                        if (throwable != null) {
                            try {
                                sourceFileWriter2.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        sourceFileWriter2.close();
                    }
                }
                for (Change change : changes.refactoredInPlace) {
                    sourceFileWriter = Files.newBufferedWriter(this.project.getBasedir().toPath().resolve(Paths.get(change.getOriginal().getSourcePath(), new String[0])), new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        sourceFileWriter.write(change.getFixed().print());
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (sourceFileWriter == null) continue;
                        if (throwable != null) {
                            try {
                                sourceFileWriter.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        sourceFileWriter.close();
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to rewrite source files", (Exception)e);
            }
        }
    }
}

