/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collection;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.openrewrite.Recipe;
import org.openrewrite.config.Environment;
import org.openrewrite.maven.AbstractRewriteMojo;

@Mojo(name="discover", threadSafe=true)
public class RewriteDiscoverMojo
extends AbstractRewriteMojo {
    private final Log log = this.getLog();

    public void execute() throws MojoExecutionException {
        Environment env = this.environment();
        Collection recipesByName = env.listRecipes();
        this.log.info((CharSequence)("Found " + this.activeRecipes.size() + " active recipes and " + recipesByName.size() + " total recipes.\n"));
        this.log.info((CharSequence)"Active Recipes:");
        for (String activeRecipe : this.activeRecipes) {
            this.log.info((CharSequence)("\t" + activeRecipe));
        }
        this.log.info((CharSequence)"");
        this.log.info((CharSequence)"All Recipes:");
        for (Recipe recipe : recipesByName) {
            this.log.info((CharSequence)("\tname: " + recipe.getName()));
        }
    }
}

