/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collection;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.openrewrite.Recipe;
import org.openrewrite.config.Environment;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.maven.AbstractRewriteMojo;

@Mojo(name="discover", threadSafe=true)
public class RewriteDiscoverMojo
extends AbstractRewriteMojo {
    private final Log log = this.getLog();

    public void execute() throws MojoExecutionException {
        Environment env = this.environment();
        String recipeFilter = System.getProperty("rewrite.discover.recipe");
        String verboseProperty = System.getProperty("rewrite.discover.verbose");
        boolean verbose = Boolean.parseBoolean(verboseProperty);
        String recursiveProperty = System.getProperty("rewrite.discover.recursive");
        boolean recursive = Boolean.parseBoolean(recursiveProperty);
        if (recipeFilter != null) {
            RecipeDescriptor recipeDescriptor = env.listRecipeDescriptors().stream().filter(r -> r.getName().equals(recipeFilter)).findAny().orElse(null);
            if (recipeDescriptor == null) {
                this.log.info((CharSequence)("Recipe " + recipeFilter + " not found."));
            } else {
                this.logRecipeDescriptor(recipeDescriptor, verbose, recursive);
            }
            return;
        }
        Collection recipesByName = env.listRecipes();
        this.log.info((CharSequence)("Found " + this.activeRecipes.size() + " active recipes and " + recipesByName.size() + " activatable recipes."));
        this.log.info((CharSequence)"");
        this.log.info((CharSequence)"Active Recipes:");
        for (String activeRecipe : this.activeRecipes) {
            this.log.info((CharSequence)("    " + activeRecipe));
        }
        this.log.info((CharSequence)"");
        this.log.info((CharSequence)"Activatable Recipes:");
        for (Recipe recipe : recipesByName) {
            this.log.info((CharSequence)("    " + recipe.getName()));
        }
        this.log.info((CharSequence)"");
        this.log.info((CharSequence)"Descriptors:");
        for (RecipeDescriptor recipeDescriptor : env.listRecipeDescriptors()) {
            this.logRecipeDescriptor(recipeDescriptor, verbose, recursive);
        }
    }

    private void logRecipeDescriptor(RecipeDescriptor recipeDescriptor, boolean verbose, boolean recursive) {
        if (verbose) {
            this.log.info((CharSequence)("    Name: " + recipeDescriptor.getName()));
            this.log.info((CharSequence)("    Display name: " + recipeDescriptor.getDisplayName()));
            this.log.info((CharSequence)("    Description: " + recipeDescriptor.getDescription()));
            if (!recipeDescriptor.getTags().isEmpty()) {
                this.log.info((CharSequence)("    Tags: " + String.join((CharSequence)",", recipeDescriptor.getTags())));
            }
        } else {
            this.log.info((CharSequence)("    " + recipeDescriptor.getName()));
        }
        if (!recipeDescriptor.getOptions().isEmpty()) {
            if (verbose) {
                this.log.info((CharSequence)"    Options:");
            }
            for (OptionDescriptor optionDescriptor : recipeDescriptor.getOptions()) {
                StringBuilder optionBuilder = new StringBuilder(optionDescriptor.getName()).append(": ").append(optionDescriptor.getType());
                if (optionDescriptor.isRequired()) {
                    optionBuilder.append("!");
                }
                this.log.info((CharSequence)("        " + optionBuilder.toString()));
                if (!verbose) continue;
                this.log.info((CharSequence)("        Display name: " + optionDescriptor.getDisplayName()));
                this.log.info((CharSequence)("        Description: " + optionDescriptor.getDescription()));
                this.log.info((CharSequence)"");
            }
        }
        if (!recipeDescriptor.getRecipeList().isEmpty()) {
            if (verbose) {
                this.log.info((CharSequence)"    Recipe list:");
            }
            for (RecipeDescriptor r : recipeDescriptor.getRecipeList()) {
                this.logNestedRecipeDescriptor(r, verbose, recursive, "        ");
            }
            if (verbose) {
                this.log.info((CharSequence)"");
            }
        }
        if (!verbose || recipeDescriptor.getOptions().isEmpty() && recipeDescriptor.getRecipeList().isEmpty()) {
            this.log.info((CharSequence)"");
        }
    }

    private void logNestedRecipeDescriptor(RecipeDescriptor recipeDescriptor, boolean verbose, boolean recursive, String indent) {
        if (verbose) {
            this.log.info((CharSequence)(indent + "Name: " + recipeDescriptor.getName()));
            this.log.info((CharSequence)(indent + "Display name: " + recipeDescriptor.getDisplayName()));
            this.log.info((CharSequence)(indent + "Description: " + recipeDescriptor.getDescription()));
            if (!recipeDescriptor.getTags().isEmpty()) {
                this.log.info((CharSequence)(indent + "Tags: " + String.join((CharSequence)",", recipeDescriptor.getTags())));
            }
        } else {
            this.log.info((CharSequence)(indent + recipeDescriptor.getName()));
        }
        if (!recipeDescriptor.getOptions().isEmpty()) {
            if (verbose) {
                this.log.info((CharSequence)(indent + "Options:"));
            }
            for (OptionDescriptor optionDescriptor : recipeDescriptor.getOptions()) {
                this.log.info((CharSequence)(indent + "    " + optionDescriptor.getName() + ": " + optionDescriptor.getValue()));
            }
            if (verbose) {
                this.log.info((CharSequence)"");
            }
        }
        if (recursive && !recipeDescriptor.getRecipeList().isEmpty()) {
            if (verbose) {
                this.log.info((CharSequence)(indent + "Recipe list:"));
            }
            for (RecipeDescriptor nestedRecipeDescriptor : recipeDescriptor.getRecipeList()) {
                this.logNestedRecipeDescriptor(nestedRecipeDescriptor, verbose, true, indent + "    ");
            }
            if (verbose) {
                this.log.info((CharSequence)"");
            }
        }
        if (!verbose || recipeDescriptor.getOptions().isEmpty() && recipeDescriptor.getRecipeList().isEmpty()) {
            this.log.info((CharSequence)"");
        }
    }
}

