/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.openrewrite.config.Environment;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AbstractRewriteMojo;
import org.openrewrite.maven.ui.RecipeDescriptorTreePrompter;
import org.openrewrite.style.NamedStyles;

@Mojo(name="discover", threadSafe=true)
public class RewriteDiscoverMojo
extends AbstractRewriteMojo {
    @Nullable
    @Parameter(property="recipe")
    String recipe;
    @Parameter(property="detail", defaultValue="false")
    boolean detail;
    @Parameter(property="recursion", defaultValue="0")
    int recursion;
    @Parameter(property="interactive", defaultValue="false")
    boolean interactive;
    @Component
    private Prompter prompter;

    public void execute() throws MojoExecutionException {
        Environment env = this.environment();
        Collection availableRecipeDescriptors = env.listRecipeDescriptors();
        if (this.recipe != null) {
            RecipeDescriptor rd = RewriteDiscoverMojo.getRecipeDescriptor(this.recipe, availableRecipeDescriptors);
            this.writeRecipeDescriptor(rd, this.detail, 0, 0);
        } else if (this.interactive) {
            this.getLog().info((CharSequence)"Entering interactive mode, Ctrl-C to exit...");
            RecipeDescriptorTreePrompter treePrompter = new RecipeDescriptorTreePrompter(this.prompter);
            RecipeDescriptor rd = treePrompter.execute(availableRecipeDescriptors);
            this.writeRecipeDescriptor(rd, true, 0, 0);
        } else {
            HashSet<RecipeDescriptor> activeRecipeDescriptors = new HashSet<RecipeDescriptor>();
            for (String activeRecipe : this.activeRecipes) {
                RecipeDescriptor rd = RewriteDiscoverMojo.getRecipeDescriptor(activeRecipe, availableRecipeDescriptors);
                activeRecipeDescriptors.add(rd);
            }
            this.writeDiscovery(availableRecipeDescriptors, activeRecipeDescriptors, env.listStyles());
        }
    }

    private void writeDiscovery(Collection<RecipeDescriptor> availableRecipeDescriptors, Collection<RecipeDescriptor> activeRecipeDescriptors, Collection<NamedStyles> availableStyles) {
        this.getLog().info((CharSequence)"Available Recipes:");
        for (RecipeDescriptor recipeDescriptor : availableRecipeDescriptors) {
            this.writeRecipeDescriptor(recipeDescriptor, this.detail, 0, 1);
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Available Styles:");
        for (NamedStyles style : availableStyles) {
            this.getLog().info((CharSequence)("    " + style.getName()));
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Active Styles:");
        for (String activeStyle : this.activeStyles) {
            this.getLog().info((CharSequence)("    " + activeStyle));
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Active Recipes:");
        for (RecipeDescriptor recipeDescriptor : activeRecipeDescriptors) {
            this.writeRecipeDescriptor(recipeDescriptor, this.detail, 0, 1);
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("Found " + availableRecipeDescriptors.size() + " available recipes and " + availableStyles.size() + " available styles."));
        this.getLog().info((CharSequence)("Configured with " + activeRecipeDescriptors.size() + " active recipes and " + this.activeStyles.size() + " active styles."));
    }

    private void writeRecipeDescriptor(RecipeDescriptor rd, boolean verbose, int currentRecursionLevel, int indentLevel) {
        String indent = StringUtils.repeat((String)"    ", (int)(indentLevel * 4));
        if (currentRecursionLevel <= this.recursion) {
            if (verbose) {
                this.getLog().info((CharSequence)(indent + rd.getDisplayName()));
                this.getLog().info((CharSequence)(indent + "    " + rd.getName()));
                if (!rd.getDescription().isEmpty()) {
                    this.getLog().info((CharSequence)(indent + "    " + rd.getDescription()));
                }
                if (!rd.getOptions().isEmpty()) {
                    this.getLog().info((CharSequence)(indent + "options: "));
                    for (OptionDescriptor od : rd.getOptions()) {
                        this.getLog().info((CharSequence)(indent + "    " + od.getName() + ": " + od.getType() + (od.isRequired() ? "!" : "")));
                        if (od.getDescription() == null || od.getDescription().isEmpty()) continue;
                        this.getLog().info((CharSequence)(indent + "        " + od.getDescription()));
                    }
                }
            } else {
                this.getLog().info((CharSequence)(indent + rd.getName()));
            }
            if (!rd.getRecipeList().isEmpty() && currentRecursionLevel + 1 <= this.recursion) {
                this.getLog().info((CharSequence)(indent + "recipeList:"));
                for (RecipeDescriptor r : rd.getRecipeList()) {
                    this.writeRecipeDescriptor(r, verbose, currentRecursionLevel + 1, indentLevel + 1);
                }
            }
            if (verbose) {
                this.getLog().info((CharSequence)"");
            }
        }
    }
}

