/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.marker.BuildTool;
import org.openrewrite.marker.Generated;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.ResourceParser;
import org.openrewrite.maven.cache.InMemoryMavenPomCache;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.cache.RocksdbMavenPomCache;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.style.NamedStyles;

public class MavenMojoProjectParser {
    private final Log logger;
    private final Path baseDir;
    private final MavenProject mavenProject;
    private final List<Marker> projectProvenance;

    public MavenMojoProjectParser(Log logger, Path baseDir, MavenProject mavenProject, RuntimeInformation runtime) {
        String propertiesTargetCompatibility;
        this.logger = logger;
        this.baseDir = baseDir;
        this.mavenProject = mavenProject;
        String javaRuntimeVersion = System.getProperty("java.runtime.version");
        String javaVendor = System.getProperty("java.vm.vendor");
        String sourceCompatibility = javaRuntimeVersion;
        String targetCompatibility = javaRuntimeVersion;
        String propertiesSourceCompatibility = (String)mavenProject.getProperties().get("maven.compiler.source");
        if (propertiesSourceCompatibility != null) {
            sourceCompatibility = propertiesSourceCompatibility;
        }
        if ((propertiesTargetCompatibility = (String)mavenProject.getProperties().get("maven.compiler.target")) != null) {
            targetCompatibility = propertiesTargetCompatibility;
        }
        this.projectProvenance = Arrays.asList(GitProvenance.fromProjectDirectory((Path)baseDir), new BuildTool(Tree.randomId(), BuildTool.Type.Maven, runtime.getMavenVersion()), new JavaVersion(Tree.randomId(), javaRuntimeVersion, javaVendor, sourceCompatibility, targetCompatibility), new JavaProject(Tree.randomId(), mavenProject.getName(), new JavaProject.Publication(mavenProject.getGroupId(), mavenProject.getArtifactId(), mavenProject.getVersion())));
    }

    @Nullable
    public Maven parseMaven(boolean pomCacheEnabled, @Nullable String pomCacheDirectory, ExecutionContext ctx) {
        MavenSettings settings;
        Path mavenSettings;
        if (System.getProperty("skipMavenParsing") != null) {
            return null;
        }
        ArrayList<Path> allPoms = new ArrayList<Path>();
        allPoms.add(this.mavenProject.getFile().toPath());
        if (this.mavenProject.getCollectedProjects() != null) {
            this.mavenProject.getCollectedProjects().stream().filter(collectedProject -> collectedProject != this.mavenProject).map(collectedProject -> collectedProject.getFile().toPath()).forEach(allPoms::add);
        }
        for (MavenProject parent = this.mavenProject.getParent(); parent != null && parent.getFile() != null; parent = parent.getParent()) {
            allPoms.add(parent.getFile().toPath());
        }
        MavenParser.Builder mavenParserBuilder = MavenParser.builder().mavenConfig(this.baseDir.resolve(".mvn/maven.config"));
        if (pomCacheEnabled) {
            try {
                if (pomCacheDirectory == null) {
                    mavenParserBuilder.cache((MavenPomCache)new RocksdbMavenPomCache(Paths.get(System.getProperty("user.home"), new String[0])));
                } else {
                    mavenParserBuilder.cache((MavenPomCache)new RocksdbMavenPomCache(Paths.get(pomCacheDirectory, new String[0])));
                }
            }
            catch (Exception e) {
                this.logger.warn((CharSequence)"Unable to initialize RocksdbMavenPomCache, falling back to InMemoryMavenPomCache");
                this.logger.debug((Throwable)e);
                mavenParserBuilder.cache((MavenPomCache)new InMemoryMavenPomCache());
            }
        }
        if ((mavenSettings = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".m2/settings.xml")).toFile().exists() && (settings = MavenSettings.parse((Parser.Input)new Parser.Input(mavenSettings, () -> {
            try {
                return Files.newInputStream(mavenSettings, new OpenOption[0]);
            }
            catch (IOException e) {
                this.logger.warn((CharSequence)"Unable to load Maven settings from user home directory. Skipping.", (Throwable)e);
                return null;
            }
        }), (ExecutionContext)ctx)) != null) {
            new MavenExecutionContextView(ctx).setMavenSettings(settings, new String[0]);
            if (settings.getActiveProfiles() != null) {
                mavenParserBuilder.activeProfiles(settings.getActiveProfiles().getActiveProfiles().toArray(new String[0]));
            }
        }
        Maven mavenSource = (Maven)mavenParserBuilder.build().parse(allPoms, this.baseDir, ctx).iterator().next();
        for (Marker marker : this.projectProvenance) {
            mavenSource = mavenSource.withMarkers(mavenSource.getMarkers().addIfAbsent(marker));
        }
        return mavenSource;
    }

    public List<SourceFile> listSourceFiles(Iterable<NamedStyles> styles, ExecutionContext ctx) throws DependencyResolutionRequiredException, MojoExecutionException {
        HashSet<Path> alreadyParsed = new HashSet<Path>();
        JavaParser javaParser = JavaParser.fromJavaVersion().relaxedClassTypeMatching(true).styles(styles).logCompilationWarningsAndErrors(false).build();
        List<Path> generatedSourcePaths = MavenMojoProjectParser.listJavaSources(this.mavenProject.getBuild().getDirectory());
        List mainJavaSources = Stream.concat(generatedSourcePaths.stream(), MavenMojoProjectParser.listJavaSources(this.mavenProject.getBuild().getSourceDirectory()).stream()).collect(Collectors.toList());
        this.logger.info((CharSequence)"Parsing Java main files...");
        List dependencies = this.mavenProject.getCompileClasspathElements().stream().distinct().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        javaParser.setClasspath(dependencies);
        JavaSourceSet mainProvenance = JavaSourceSet.build((String)"main", dependencies, (ExecutionContext)ctx);
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>(ListUtils.map((List)javaParser.parse(mainJavaSources, this.baseDir, ctx), this.addProvenance(this.baseDir, this.projectProvenance, mainProvenance, generatedSourcePaths)));
        ResourceParser rp = new ResourceParser(this.logger);
        sourceFiles.addAll(ListUtils.map(rp.parse(this.baseDir, this.mavenProject.getBasedir().toPath().resolve("src/main/resources"), alreadyParsed), this.addProvenance(this.baseDir, this.projectProvenance, mainProvenance, null)));
        this.logger.info((CharSequence)"Parsing Java test files...");
        List testDependencies = this.mavenProject.getTestClasspathElements().stream().distinct().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        javaParser.setClasspath(testDependencies);
        JavaSourceSet testProvenance = JavaSourceSet.build((String)"test", dependencies, (ExecutionContext)ctx);
        sourceFiles.addAll(ListUtils.map((List)javaParser.parse(MavenMojoProjectParser.listJavaSources(this.mavenProject.getBuild().getTestSourceDirectory()), this.baseDir, ctx), this.addProvenance(this.baseDir, this.projectProvenance, testProvenance, null)));
        sourceFiles.addAll(ListUtils.map(rp.parse(this.baseDir, this.mavenProject.getBasedir().toPath().resolve("src/test/resources"), alreadyParsed), this.addProvenance(this.baseDir, this.projectProvenance, testProvenance, null)));
        sourceFiles.addAll(ListUtils.map(rp.parse(this.baseDir, this.mavenProject.getBasedir().toPath(), alreadyParsed), this.addProvenance(this.baseDir, this.projectProvenance, null, null)));
        return sourceFiles;
    }

    private <S extends SourceFile> UnaryOperator<S> addProvenance(Path baseDir, List<Marker> provenance, @Nullable JavaSourceSet sourceSet, @Nullable Collection<Path> generatedSources) {
        return s -> {
            for (Marker marker : provenance) {
                s = s.withMarkers(s.getMarkers().addIfAbsent(marker));
            }
            if (sourceSet != null) {
                s = s.withMarkers(s.getMarkers().addIfAbsent((Marker)sourceSet));
            }
            if (generatedSources != null && generatedSources.contains(baseDir.resolve(s.getSourcePath()))) {
                s = s.withMarkers(s.getMarkers().addIfAbsent((Marker)new Generated(Tree.randomId())));
            }
            return s;
        };
    }

    public static List<Path> listJavaSources(String sourceDirectory) throws MojoExecutionException {
        File sourceDirectoryFile = new File(sourceDirectory);
        if (!sourceDirectoryFile.exists()) {
            return Collections.emptyList();
        }
        Path sourceRoot = sourceDirectoryFile.toPath();
        try {
            return Files.walk(sourceRoot, new FileVisitOption[0]).filter(f -> !Files.isDirectory(f, new LinkOption[0]) && f.toFile().getName().endsWith(".java")).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to list Java source files", (Exception)e);
        }
    }
}

