/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.hcl.HclParser;
import org.openrewrite.json.JsonParser;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.yaml.YamlParser;

public class ResourceParser {
    private final Log logger;
    private final Collection<String> exclusions;

    public ResourceParser(Log logger, Collection<String> exclusions) {
        this.logger = logger;
        this.exclusions = exclusions;
    }

    public List<SourceFile> parse(Path baseDir, Path searchDir, Collection<Path> alreadyParsed) {
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        if (!searchDir.toFile().exists()) {
            return sourceFiles;
        }
        Consumer<Throwable> errorConsumer = t -> this.logger.error((CharSequence)"Error parsing", t);
        InMemoryExecutionContext ctx = new InMemoryExecutionContext(errorConsumer);
        sourceFiles.addAll(this.parseSourceFiles(baseDir, (Parser)new JsonParser(), searchDir, alreadyParsed, (ExecutionContext)ctx));
        sourceFiles.addAll(this.parseSourceFiles(baseDir, (Parser)new XmlParser(), searchDir, alreadyParsed, (ExecutionContext)ctx));
        sourceFiles.addAll(this.parseSourceFiles(baseDir, (Parser)new YamlParser(), searchDir, alreadyParsed, (ExecutionContext)ctx));
        sourceFiles.addAll(this.parseSourceFiles(baseDir, (Parser)new PropertiesParser(), searchDir, alreadyParsed, (ExecutionContext)ctx));
        sourceFiles.addAll(this.parseSourceFiles(baseDir, (Parser)HclParser.builder().build(), searchDir, alreadyParsed, (ExecutionContext)ctx));
        return sourceFiles;
    }

    public <S extends SourceFile> List<S> parseSourceFiles(Path baseDir, Parser<S> parser, Path searchDir, Collection<Path> alreadyParsed, ExecutionContext ctx) {
        try {
            List resourceFiles = Files.find(searchDir, 16, (path, attrs) -> {
                try {
                    if (path.toString().contains("/target/") || path.toString().contains("/build/") || path.toString().contains("/out/") || path.toString().contains("/node_modules/") || path.toString().contains("/.metadata/")) {
                        return false;
                    }
                    for (String exclusion : this.exclusions) {
                        PathMatcher matcher = baseDir.getFileSystem().getPathMatcher("glob:" + exclusion);
                        if (!matcher.matches(baseDir.relativize((Path)path))) continue;
                        return false;
                    }
                    if (alreadyParsed.contains(searchDir.relativize((Path)path))) {
                        return false;
                    }
                    if (attrs.isDirectory() || Files.size(path) == 0L) {
                        return false;
                    }
                }
                catch (IOException e) {
                    this.logger.warn((CharSequence)e.getMessage(), (Throwable)e);
                }
                return parser.accept(path);
            }, new FileVisitOption[0]).collect(Collectors.toList());
            return parser.parse(resourceFiles, baseDir, ctx);
        }
        catch (IOException e) {
            this.logger.error((CharSequence)e.getMessage(), (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }
}

