/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;

public class MavenOptsHelper {
    public static void checkAndLogMissingJvmModuleExports(Log log) {
        try {
            String version = System.getProperty("java.version");
            int dot = version.indexOf(46);
            String majorVersionString = dot > 0 ? version.substring(0, dot) : version;
            int majorVersion = Integer.parseInt(majorVersionString);
            if (majorVersion > 15) {
                String mavenOpts = System.getenv().getOrDefault("MAVEN_OPTS", "");
                Pattern pattern = Pattern.compile("--add-exports\\sjdk\\.compiler/com\\.sun\\.tools\\.javac\\.(\\w+)=ALL-UNNAMED");
                Matcher matcher = pattern.matcher(mavenOpts);
                List<String> requiredExportPackages = Arrays.asList("code", "comp", "file", "jvm", "main", "model", "processing", "tree", "util");
                HashSet<String> exportedPackages = new HashSet<String>(requiredExportPackages);
                while (matcher.find()) {
                    String pkg = matcher.group(1);
                    exportedPackages.remove(pkg);
                }
                if (!exportedPackages.isEmpty()) {
                    StringBuilder errMessage = new StringBuilder("Java ").append(version).append(" protected module access not exported for:");
                    for (String missingModuleExport : exportedPackages) {
                        errMessage.append("\n\tcom.sun.tools.javac.").append(missingModuleExport);
                    }
                    log.error((CharSequence)errMessage);
                    log.warn((CharSequence)"The following exports should be added to your MAVEN_OPTS environment variable.");
                    StringBuilder infoMessage = new StringBuilder();
                    for (String exp : requiredExportPackages) {
                        infoMessage.append("--add-exports jdk.compiler/com.sun.tools.javac.").append(exp).append("=ALL-UNNAMED ");
                    }
                    log.info((CharSequence)infoMessage);
                    log.info((CharSequence)"");
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }
}

