/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.logging.Log;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.hcl.HclParser;
import org.openrewrite.json.JsonParser;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.yaml.YamlParser;

public class ResourceParser {
    private final Log logger;
    private final Collection<String> exclusions;
    private final int sizeThresholdMb;

    public ResourceParser(Log logger, Collection<String> exclusions, int thresholdMb) {
        this.logger = logger;
        this.exclusions = exclusions;
        this.sizeThresholdMb = thresholdMb;
    }

    public List<SourceFile> parse(Path baseDir, Path searchDir, Collection<Path> alreadyParsed) {
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        if (!searchDir.toFile().exists()) {
            return sourceFiles;
        }
        Consumer<Throwable> errorConsumer = t -> this.logger.error((CharSequence)"Error parsing", t);
        InMemoryExecutionContext ctx = new InMemoryExecutionContext(errorConsumer);
        sourceFiles.addAll(this.parseSourceFiles(baseDir, (Parser)new JsonParser(), searchDir, alreadyParsed, (ExecutionContext)ctx));
        sourceFiles.addAll(this.parseSourceFiles(baseDir, (Parser)new XmlParser(), searchDir, alreadyParsed, (ExecutionContext)ctx));
        sourceFiles.addAll(this.parseSourceFiles(baseDir, (Parser)new YamlParser(), searchDir, alreadyParsed, (ExecutionContext)ctx));
        sourceFiles.addAll(this.parseSourceFiles(baseDir, (Parser)new PropertiesParser(), searchDir, alreadyParsed, (ExecutionContext)ctx));
        sourceFiles.addAll(this.parseSourceFiles(baseDir, (Parser)HclParser.builder().build(), searchDir, alreadyParsed, (ExecutionContext)ctx));
        return sourceFiles;
    }

    public <S extends SourceFile> List<S> parseSourceFiles(Path baseDir, Parser<S> parser, Path searchDir, Collection<Path> alreadyParsed, ExecutionContext ctx) {
        List list;
        block8: {
            Stream<Path> resources = Files.find(searchDir, 16, (path, attrs) -> {
                if (!parser.accept(path)) {
                    return false;
                }
                String pathStr = path.toString();
                if (pathStr.contains("/target/") || pathStr.contains("/build/") || pathStr.contains("/out/") || pathStr.contains("/.gradle/") || pathStr.contains("/node_modules/") || pathStr.contains("/.metadata/")) {
                    return false;
                }
                if (attrs.isDirectory() || attrs.size() == 0L) {
                    return false;
                }
                if (alreadyParsed.contains(path)) {
                    return false;
                }
                for (String exclusion : this.exclusions) {
                    PathMatcher matcher = baseDir.getFileSystem().getPathMatcher("glob:" + exclusion);
                    if (!matcher.matches(baseDir.relativize((Path)path))) continue;
                    alreadyParsed.add((Path)path);
                    return false;
                }
                long fileSize = attrs.size();
                if (this.sizeThresholdMb > 0 && fileSize > (long)this.sizeThresholdMb * 1024L * 1024L) {
                    alreadyParsed.add((Path)path);
                    this.logger.info((CharSequence)("Skipping parsing " + path + " as its size + " + fileSize / 0x100000L + "Mb exceeds size threshold " + this.sizeThresholdMb + "Mb"));
                    return false;
                }
                return true;
            }, new FileVisitOption[0]);
            try {
                List resourceFiles = resources.collect(Collectors.toList());
                alreadyParsed.addAll(resourceFiles);
                list = parser.parse(resourceFiles, baseDir, ctx);
                if (resources == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resources != null) {
                        try {
                            resources.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.logger.error((CharSequence)e.getMessage(), (Throwable)e);
                    throw new UncheckedIOException(e);
                }
            }
            resources.close();
        }
        return list;
    }
}

