/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.Result;
import org.openrewrite.Validated;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.maven.MavenParser;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.MeterRegistryProvider;
import org.openrewrite.maven.cache.InMemoryMavenPomCache;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.cache.RocksdbMavenPomCache;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.yaml.YamlParser;

public abstract class AbstractRewriteMojo
extends AbstractMojo {
    @Parameter(property="configLocation", defaultValue="${maven.multiModuleProjectDirectory}/rewrite.yml")
    String configLocation;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="activeRecipes")
    protected Set<String> activeRecipes = Collections.emptySet();
    @Parameter(property="activeStyles")
    protected Set<String> activeStyles = Collections.emptySet();
    @Nullable
    @Parameter(property="metricsUri")
    private String metricsUri;
    @Nullable
    @Parameter(property="metricsUsername")
    private String metricsUsername;
    @Nullable
    @Parameter(property="metricsPassword")
    private String metricsPassword;
    @Parameter(property="pomCacheEnabled", defaultValue="true")
    private boolean pomCacheEnabled;
    @Nullable
    @Parameter(property="pomCacheDirectory")
    private String pomCacheDirectory;
    @Parameter(property="failOnInvalidActiveRecipes", defaultValue="false")
    private boolean failOnInvalidActiveRecipes;
    private static final String LOG_INDENT_INCREMENT = "    ";
    private static final String RECIPE_NOT_FOUND_EXCEPTION_MSG = "Could not find recipe '%s' among available recipes";
    protected boolean suppressWarnings = false;

    protected Environment environment() throws MojoExecutionException {
        File rewriteConfig;
        Environment.Builder env = Environment.builder((Properties)this.project.getProperties()).scanRuntimeClasspath(new String[0]).scanClasspath((Iterable)this.project.getArtifacts().stream().map(d -> d.getFile().toPath()).collect(Collectors.toList()), new String[0]).scanUserHome();
        Path absoluteConfigLocation = Paths.get(this.configLocation, new String[0]);
        if (!absoluteConfigLocation.isAbsolute()) {
            absoluteConfigLocation = this.project.getBasedir().toPath().resolve(this.configLocation);
        }
        if ((rewriteConfig = absoluteConfigLocation.toFile()).exists()) {
            try (FileInputStream is = new FileInputStream(rewriteConfig);){
                env.load((ResourceLoader)new YamlResourceLoader((InputStream)is, rewriteConfig.toURI(), this.project.getProperties()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to load rewrite configuration", (Exception)e);
            }
        }
        return env.build();
    }

    protected ExecutionContext executionContext() {
        return new InMemoryExecutionContext(t -> {
            if (!this.suppressWarnings) {
                this.getLog().warn((CharSequence)t.getMessage());
            }
            this.getLog().debug(t);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Maven parseMaven(Path baseDir, ExecutionContext ctx) {
        MavenSettings settings;
        Path mavenSettings;
        ArrayList<Path> allPoms = new ArrayList<Path>();
        allPoms.add(this.project.getFile().toPath());
        if (this.project.getCollectedProjects() != null) {
            this.project.getCollectedProjects().stream().filter(collectedProject -> collectedProject != this.project).map(collectedProject -> collectedProject.getFile().toPath()).forEach(allPoms::add);
        }
        for (MavenProject parent = this.project.getParent(); parent != null && parent.getFile() != null; parent = parent.getParent()) {
            allPoms.add(parent.getFile().toPath());
        }
        MavenParser.Builder mavenParserBuilder = MavenParser.builder().mavenConfig(baseDir.resolve(".mvn/maven.config"));
        if (this.pomCacheEnabled) {
            try {
                if (this.pomCacheDirectory == null) {
                    mavenParserBuilder.cache((MavenPomCache)new RocksdbMavenPomCache(Paths.get(System.getProperty("user.home"), ".rewrite", "cache", "pom").toFile()));
                } else {
                    mavenParserBuilder.cache((MavenPomCache)new RocksdbMavenPomCache(Paths.get(this.pomCacheDirectory, new String[0]).toFile()));
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)"Unable to initialize RocksdbMavenPomCache, falling back to InMemoryMavenPomCache");
                this.getLog().debug((Throwable)e);
                mavenParserBuilder.cache((MavenPomCache)new InMemoryMavenPomCache());
            }
        }
        if ((mavenSettings = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".m2/settings.xml")).toFile().exists() && (settings = MavenSettings.parse((Parser.Input)new Parser.Input(mavenSettings, () -> {
            try {
                return Files.newInputStream(mavenSettings, new OpenOption[0]);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Unable to load Maven settings from user home directory. Skipping.", (Throwable)e);
                return null;
            }
        }), (ExecutionContext)ctx, (String[])new String[0])) != null && settings.getActiveProfiles() != null) {
            mavenParserBuilder.activeProfiles(settings.getActiveProfiles().getActiveProfiles().toArray(new String[0]));
        }
        try {
            this.suppressWarnings = true;
            Maven maven = (Maven)mavenParserBuilder.build().parse(allPoms, baseDir, ctx).iterator().next();
            return maven;
        }
        finally {
            this.suppressWarnings = false;
        }
    }

    protected Path getBaseDir() {
        Object maybeMultiModuleDir = System.getProperties().get("maven.multiModuleProjectDirectory");
        try {
            if (maybeMultiModuleDir instanceof String) {
                return Paths.get((String)maybeMultiModuleDir, new String[0]).toRealPath(new LinkOption[0]);
            }
            return this.project.getBasedir().toPath().toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResultsContainer listResults() throws MojoExecutionException {
        try (MeterRegistryProvider meterRegistryProvider = new MeterRegistryProvider(this.getLog(), this.metricsUri, this.metricsUsername, this.metricsPassword);){
            MeterRegistry meterRegistry = meterRegistryProvider.registry();
            Path baseDir = this.getBaseDir();
            this.getLog().info((CharSequence)String.format("Using active recipe(s) %s", this.activeRecipes));
            this.getLog().info((CharSequence)String.format("Using active styles(s) %s", this.activeStyles));
            if (this.activeRecipes.isEmpty()) {
                ResultsContainer resultsContainer = new ResultsContainer(baseDir, Collections.emptyList());
                return resultsContainer;
            }
            Environment env = this.environment();
            List styles = env.activateStyles(this.activeStyles);
            Recipe recipe = env.activateRecipes(this.activeRecipes);
            this.getLog().info((CharSequence)"Validating active recipes...");
            Collection validated = recipe.validateAll();
            List<Validated.Invalid> failedValidations = validated.stream().map(Validated::failures).flatMap(Collection::stream).collect(Collectors.toList());
            if (!failedValidations.isEmpty()) {
                failedValidations.forEach(failedValidation -> this.getLog().error((CharSequence)("Recipe validation error in " + failedValidation.getProperty() + ": " + failedValidation.getMessage()), failedValidation.getException()));
                if (this.failOnInvalidActiveRecipes) {
                    throw new MojoExecutionException("Recipe validation errors detected as part of one or more activeRecipe(s). Please check error logs.");
                }
                this.getLog().error((CharSequence)"Recipe validation errors detected as part of one or more activeRecipe(s). Execution will continue regardless.");
            }
            ArrayList<Maven> sourceFiles = new ArrayList<Maven>();
            ArrayList<Path> javaSources = new ArrayList<Path>();
            javaSources.addAll(AbstractRewriteMojo.listJavaSources(this.project.getBuild().getSourceDirectory()));
            javaSources.addAll(AbstractRewriteMojo.listJavaSources(this.project.getBuild().getTestSourceDirectory()));
            ExecutionContext ctx = this.executionContext();
            this.getLog().info((CharSequence)"Parsing Java files...");
            sourceFiles.addAll(JavaParser.fromJavaVersion().styles((Iterable)styles).classpath((Collection)Stream.concat(this.project.getCompileClasspathElements().stream(), this.project.getTestClasspathElements().stream()).distinct().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList())).logCompilationWarningsAndErrors(false).build().parse(javaSources, baseDir, ctx));
            HashSet<Path> resources = new HashSet<Path>();
            for (Resource resource : this.project.getBuild().getResources()) {
                this.addToResources(ctx, resources, resource);
            }
            for (Resource resource : this.project.getBuild().getTestResources()) {
                this.addToResources(ctx, resources, resource);
            }
            this.getLog().info((CharSequence)"Parsing YAML files...");
            sourceFiles.addAll(new YamlParser().parse((Iterable)resources.stream().filter(it -> it.getFileName().toString().endsWith(".yml") || it.getFileName().toString().endsWith(".yaml")).collect(Collectors.toList()), baseDir, ctx));
            this.getLog().info((CharSequence)"Parsing properties files...");
            sourceFiles.addAll(new PropertiesParser().parse((Iterable)resources.stream().filter(it -> it.getFileName().toString().endsWith(".properties")).collect(Collectors.toList()), baseDir, ctx));
            this.getLog().info((CharSequence)"Parsing XML files...");
            sourceFiles.addAll(new XmlParser().parse((Iterable)resources.stream().filter(it -> it.getFileName().toString().endsWith(".xml")).collect(Collectors.toList()), baseDir, ctx));
            this.getLog().info((CharSequence)"Parsing POM...");
            Maven pomAst = this.parseMaven(baseDir, ctx);
            sourceFiles.add(pomAst);
            this.getLog().info((CharSequence)"Running recipe(s)...");
            List results = recipe.run(sourceFiles, ctx);
            ResultsContainer resultsContainer = new ResultsContainer(baseDir, results);
            return resultsContainer;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Dependency resolution required", (Exception)((Object)e));
        }
    }

    private void addToResources(ExecutionContext ctx, Set<Path> resources, Resource resource) {
        File file = new File(resource.getDirectory());
        if (file.exists()) {
            BiPredicate<Path, BasicFileAttributes> predicate = (p, bfa) -> bfa.isRegularFile() && Stream.of("yml", "yaml").anyMatch(type -> p.getFileName().toString().endsWith((String)type));
            try {
                Files.find(file.toPath(), 999, predicate, new FileVisitOption[0]).forEach(resources::add);
            }
            catch (IOException e) {
                ctx.getOnError().accept(e);
            }
        }
    }

    protected static List<Path> listJavaSources(String sourceDirectory) throws MojoExecutionException {
        File sourceDirectoryFile = new File(sourceDirectory);
        if (!sourceDirectoryFile.exists()) {
            return Collections.emptyList();
        }
        Path sourceRoot = sourceDirectoryFile.toPath();
        try {
            return Files.walk(sourceRoot, new FileVisitOption[0]).filter(f -> !Files.isDirectory(f, new LinkOption[0]) && f.toFile().getName().endsWith(".java")).map(it -> {
                try {
                    return it.toRealPath(new LinkOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to list Java source files", (Exception)e);
        }
    }

    protected void logRecipesThatMadeChanges(Result result) {
        for (Recipe recipe : result.getRecipesThatMadeChanges()) {
            this.getLog().warn((CharSequence)AbstractRewriteMojo.indent(1, recipe.getName()));
        }
    }

    protected static StringBuilder indent(int indent, CharSequence content) {
        StringBuilder prefix = AbstractRewriteMojo.repeat(indent, LOG_INDENT_INCREMENT);
        return prefix.append(content);
    }

    private static StringBuilder repeat(int repeat, String str) {
        StringBuilder buffer = new StringBuilder(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer;
    }

    public static RecipeDescriptor getRecipeDescriptor(String recipe, Collection<RecipeDescriptor> recipeDescriptors) throws MojoExecutionException {
        return recipeDescriptors.stream().filter(r -> r.getName().equalsIgnoreCase(recipe)).findAny().orElseThrow(() -> new MojoExecutionException(String.format(RECIPE_NOT_FOUND_EXCEPTION_MSG, recipe)));
    }

    public static class ResultsContainer {
        final Path projectRoot;
        final List<Result> generated = new ArrayList<Result>();
        final List<Result> deleted = new ArrayList<Result>();
        final List<Result> moved = new ArrayList<Result>();
        final List<Result> refactoredInPlace = new ArrayList<Result>();

        public ResultsContainer(Path projectRoot, Collection<Result> results) {
            this.projectRoot = projectRoot;
            for (Result result : results) {
                if (result.getBefore() == null && result.getAfter() == null) continue;
                if (result.getBefore() == null && result.getAfter() != null) {
                    this.generated.add(result);
                    continue;
                }
                if (result.getBefore() != null && result.getAfter() == null) {
                    this.deleted.add(result);
                    continue;
                }
                if (result.getBefore() != null && !result.getBefore().getSourcePath().equals(result.getAfter().getSourcePath())) {
                    this.moved.add(result);
                    continue;
                }
                this.refactoredInPlace.add(result);
            }
        }

        public Path getProjectRoot() {
            return this.projectRoot;
        }

        public boolean isNotEmpty() {
            return !this.generated.isEmpty() || !this.deleted.isEmpty() || !this.moved.isEmpty() || !this.refactoredInPlace.isEmpty();
        }
    }
}

