/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.openrewrite.internal.lang.Nullable;

public abstract class ConfigurableRewriteMojo
extends AbstractMojo {
    @Parameter(property="rewrite.configLocation", alias="configLocation", defaultValue="${maven.multiModuleProjectDirectory}/rewrite.yml")
    String configLocation;
    @Parameter(property="activeRecipes")
    private Set<String> activeRecipes = Collections.emptySet();
    @Nullable
    @Parameter(property="rewrite.activeRecipes")
    private String rewriteActiveRecipes;
    @Parameter(property="activeStyles")
    private Set<String> activeStyles = Collections.emptySet();
    @Nullable
    @Parameter(property="rewrite.activeStyles")
    private String rewriteActiveStyles;
    @Nullable
    @Parameter(property="rewrite.metricsUri", alias="metricsUri")
    protected String metricsUri;
    @Nullable
    @Parameter(property="rewrite.metricsUsername", alias="metricsUsername")
    protected String metricsUsername;
    @Nullable
    @Parameter(property="rewrite.metricsPassword", alias="metricsPassword")
    protected String metricsPassword;
    @Parameter(property="rewrite.pomCacheEnabled", alias="pomCacheEnabled", defaultValue="true")
    protected boolean pomCacheEnabled;
    @Nullable
    @Parameter(property="rewrite.pomCacheDirectory", alias="pomCacheDirectory")
    protected String pomCacheDirectory;
    @Parameter(property="skipMavenParsing", defaultValue="false")
    protected boolean skipMavenParsing;
    @Nullable
    @Parameter(property="rewrite.checkstyleConfigFile", alias="checkstyleConfigFile")
    protected String checkstyleConfigFile;
    @Parameter(property="exclusions")
    private Set<String> exclusions = Collections.emptySet();
    @Nullable
    @Parameter(property="rewrite.exclusions")
    private String rewriteExclusions;
    @Nullable
    @Parameter(property="sizeThresholdMb", defaultValue="10")
    protected int sizeThresholdMb;
    @Parameter(property="rewrite.failOnInvalidActiveRecipes", alias="failOnInvalidActiveRecipes", defaultValue="false")
    protected boolean failOnInvalidActiveRecipes;
    @Nullable
    @Parameter(property="rewrite.recipeArtifactCoordinates")
    private String recipeArtifactCoordinates;
    @Nullable
    private volatile Set<String> computedRecipes;
    @Nullable
    private volatile Set<String> computedStyles;
    @Nullable
    private volatile Set<String> computedRecipeArtifactCoordinates;

    protected Set<String> getExclusions() {
        if (this.rewriteExclusions == null) {
            return this.exclusions;
        }
        Set<String> allExclusions = ConfigurableRewriteMojo.toSet(this.rewriteExclusions);
        allExclusions.addAll(this.exclusions);
        return allExclusions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getActiveRecipes() {
        if (this.computedRecipes == null) {
            ConfigurableRewriteMojo configurableRewriteMojo = this;
            synchronized (configurableRewriteMojo) {
                if (this.computedRecipes == null) {
                    Set<String> res = ConfigurableRewriteMojo.toSet(this.rewriteActiveRecipes);
                    if (res.isEmpty()) {
                        res.addAll(this.activeRecipes);
                    }
                    this.computedRecipes = Collections.unmodifiableSet(res);
                }
            }
        }
        return this.computedRecipes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getActiveStyles() {
        if (this.computedStyles == null) {
            ConfigurableRewriteMojo configurableRewriteMojo = this;
            synchronized (configurableRewriteMojo) {
                if (this.computedStyles == null) {
                    Set<String> res = ConfigurableRewriteMojo.toSet(this.rewriteActiveStyles);
                    if (res.isEmpty()) {
                        res.addAll(this.activeStyles);
                    }
                    this.computedStyles = Collections.unmodifiableSet(res);
                }
            }
        }
        return this.computedStyles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getRecipeArtifactCoordinates() {
        if (this.computedRecipeArtifactCoordinates == null) {
            ConfigurableRewriteMojo configurableRewriteMojo = this;
            synchronized (configurableRewriteMojo) {
                if (this.computedRecipeArtifactCoordinates == null) {
                    this.computedRecipeArtifactCoordinates = Collections.unmodifiableSet(ConfigurableRewriteMojo.toSet(this.recipeArtifactCoordinates));
                }
            }
        }
        return this.computedRecipeArtifactCoordinates;
    }

    private static Set<String> toSet(@Nullable String propertyValue) {
        return Optional.ofNullable(propertyValue).filter(s -> !s.isEmpty()).map(s -> new HashSet<String>(Arrays.asList(s.split(",")))).orElseGet(HashSet::new);
    }
}

