/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;

public class ArtifactResolver {
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySystemSession;
    private final List<RemoteRepository> remoteRepositories;

    public ArtifactResolver(RepositorySystem repositorySystem, MavenSession session) {
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = session.getRepositorySession();
        this.remoteRepositories = RepositoryUtils.toRepos((List)session.getCurrentProject().getRemoteArtifactRepositories());
    }

    public Artifact createArtifact(String coordinates) throws MojoExecutionException {
        String[] parts = coordinates.split(":");
        if (parts.length < 3) {
            throw new MojoExecutionException("Must include at least groupId:artifactId:version in artifact coordinates" + coordinates);
        }
        return new DefaultArtifact(parts[0], parts[1], null, "jar", parts[2]);
    }

    public Set<Artifact> resolveArtifactsAndDependencies(Set<Artifact> artifacts) throws MojoExecutionException {
        if (artifacts.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Artifact> elements = new HashSet<Artifact>();
        try {
            List dependencies = artifacts.stream().map(a -> new Dependency(a, "runtime")).collect(Collectors.toList());
            CollectRequest collectRequest = new CollectRequest(dependencies, Collections.emptyList(), this.remoteRepositories);
            DependencyRequest dependencyRequest = new DependencyRequest();
            dependencyRequest.setCollectRequest(collectRequest);
            DependencyResult dependencyResult = this.repositorySystem.resolveDependencies(this.repositorySystemSession, dependencyRequest);
            for (ArtifactResult resolved : dependencyResult.getArtifactResults()) {
                elements.add(resolved.getArtifact());
            }
            return elements;
        }
        catch (DependencyResolutionException e) {
            throw new MojoExecutionException("Failed to resolve requested artifacts transitive dependencies.", (Exception)((Object)e));
        }
    }
}

