/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.openrewrite.ExecutionContext;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.Result;
import org.openrewrite.internal.InMemoryLargeSourceSet;
import org.openrewrite.maven.AbstractRewriteMojo;
import org.openrewrite.maven.MavenMojoProjectParser;
import org.openrewrite.maven.RemovePlugin;
import org.openrewrite.xml.tree.Xml;

@Mojo(name="remove", threadSafe=true)
@Execute
public class RemoveMojo
extends AbstractRewriteMojo {
    @Parameter(property="groupId", defaultValue="org.openrewrite.maven")
    protected String groupId;
    @Parameter(property="artifactId", defaultValue="rewrite-maven-plugin")
    protected String artifactId;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path baseDir = this.getBuildRoot();
        ExecutionContext ctx = this.executionContext();
        Xml.Document maven = new MavenMojoProjectParser(this.getLog(), baseDir, this.pomCacheEnabled, this.pomCacheDirectory, this.runtime, this.skipMavenParsing, this.getExclusions(), this.getPlainTextMasks(), this.sizeThresholdMb, this.mavenSession, this.settingsDecrypter).parseMaven(this.project, Collections.emptyList(), ctx);
        InMemoryLargeSourceSet poms = new InMemoryLargeSourceSet(Collections.singletonList(maven));
        List results = new RemovePlugin(this.groupId, this.artifactId).run((LargeSourceSet)poms, ctx).getChangeset().getAllResults();
        if (!results.isEmpty()) {
            Result result = (Result)results.get(0);
            assert (result.getBefore() != null);
            assert (result.getAfter() != null);
            Charset charset = result.getAfter().getCharset() == null ? StandardCharsets.UTF_8 : result.getAfter().getCharset();
            try (BufferedWriter sourceFileWriter = Files.newBufferedWriter(baseDir.resolve(result.getBefore().getSourcePath()), charset, new OpenOption[0]);){
                sourceFileWriter.write(new String(result.getAfter().printAll().getBytes(charset), charset));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.getLog().info((CharSequence)("Removed " + this.artifactId + " from " + this.project.getFile().getPath()));
        }
    }
}

