/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.ui;

import java.util.Collection;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.maven.ui.RecipeDescriptorTree;

public class RecipeDescriptorTreePrompter {
    private static final String INDEX_TO_ANSWER_MAPPING_MSG = "[%s]: %s\n";
    private static final String AVAILABLE_OPTIONS_MSG = "Available options:\n";
    private static final String CHOOSE_NUMBER_PROMPT = "Choose a number (hint: enter to return to initial list)";
    private static final String INPUT_SELECTION_MUST_BE_NUMBER_PROMPT = "\nYour input selection must be a number, try again (hint: enter to return to initial list)";
    private static final String YOUR_SELECTION_NOT_IN_OPTIONS_PROMPT = "\nYour selection [%s] is not an option in the list, try again";
    private static final String HIGHEST_ROOT_NODE_PROMPT = "\nNo parent directory higher than this, try again";
    private final Prompter prompter;

    public RecipeDescriptorTreePrompter(Prompter prompter) {
        this.prompter = prompter;
    }

    private RecipeDescriptorTree select(RecipeDescriptorTree tree) throws MojoExecutionException {
        String prompted;
        TreeMap<String, RecipeDescriptorTree> answerSet = new TreeMap<String, RecipeDescriptorTree>();
        RecipeDescriptorTree selection = null;
        do {
            StringBuilder query = new StringBuilder(AVAILABLE_OPTIONS_MSG);
            int counter = 0;
            for (RecipeDescriptorTree option : tree.getChildren().stream().sorted().collect(Collectors.toList())) {
                String answer = String.valueOf(++counter);
                answerSet.put(answer, option);
                query.append(String.format(INDEX_TO_ANSWER_MAPPING_MSG, answer, option.getDisplayName()));
            }
            query.append(CHOOSE_NUMBER_PROMPT);
            do {
                if ((prompted = this.prompt(query.toString())).isEmpty()) {
                    if (tree.getParent() != null) {
                        return this.select(tree.getParent());
                    }
                    query.append(HIGHEST_ROOT_NODE_PROMPT);
                    continue;
                }
                if (!RecipeDescriptorTreePrompter.isNumber(prompted)) {
                    query.append(INPUT_SELECTION_MUST_BE_NUMBER_PROMPT);
                    continue;
                }
                if (answerSet.get(prompted) != null) continue;
                query.append(String.format(YOUR_SELECTION_NOT_IN_OPTIONS_PROMPT, prompted));
            } while (answerSet.get(prompted) == null);
        } while ((selection = (RecipeDescriptorTree)answerSet.get(prompted)) == null);
        if (!selection.getChildren().isEmpty()) {
            return this.select(selection);
        }
        return selection;
    }

    private static boolean isNumber(String message) {
        try {
            Integer.parseInt(message);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private String prompt(String message) throws MojoExecutionException {
        String prompted;
        try {
            prompted = this.prompter.prompt(message);
        }
        catch (PrompterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        return prompted;
    }

    public RecipeDescriptor execute(Collection<RecipeDescriptor> recipeDescriptors) throws MojoExecutionException {
        RecipeDescriptorTree tree = new RecipeDescriptorTree();
        tree.addPath(recipeDescriptors);
        RecipeDescriptorTree selection = this.select(tree);
        return selection.getRecipeDescriptor();
    }
}

