/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.nio.file.Paths;
import org.apache.maven.plugin.logging.Log;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.cache.CompositeMavenPomCache;
import org.openrewrite.maven.cache.InMemoryMavenPomCache;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.cache.RocksdbMavenPomCache;

public class MavenPomCacheBuilder {
    private final Log logger;

    public MavenPomCacheBuilder(Log logger) {
        this.logger = logger;
    }

    @Nullable
    public MavenPomCache build(@Nullable String pomCacheDirectory) {
        if (MavenPomCacheBuilder.isJvm64Bit()) {
            try {
                if (pomCacheDirectory == null) {
                    return new CompositeMavenPomCache((MavenPomCache)new InMemoryMavenPomCache(), (MavenPomCache)new RocksdbMavenPomCache(Paths.get(System.getProperty("user.home"), new String[0])));
                }
                return new CompositeMavenPomCache((MavenPomCache)new InMemoryMavenPomCache(), (MavenPomCache)new RocksdbMavenPomCache(Paths.get(pomCacheDirectory, new String[0])));
            }
            catch (Throwable e) {
                this.logger.warn((CharSequence)"Unable to initialize RocksdbMavenPomCache, falling back to InMemoryMavenPomCache");
                this.logger.debug(e);
            }
        } else {
            this.logger.warn((CharSequence)"RocksdbMavenPomCache is not supported on 32-bit JVM. falling back to InMemoryMavenPomCache");
        }
        return null;
    }

    private static boolean isJvm64Bit() {
        return !"32".equals(System.getProperty("sun.arch.data.model", "64"));
    }
}

