/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.List;
import java.util.Objects;
import org.apache.maven.plugin.logging.Log;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolutionEventListener;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;

class MavenLoggingResolutionEventListener
implements ResolutionEventListener {
    private final Log logger;

    public MavenLoggingResolutionEventListener(Log logger) {
        this.logger = Objects.requireNonNull(logger, "logger cannot be null");
    }

    public void downloadSuccess(ResolvedGroupArtifactVersion gav, @Nullable ResolvedPom containing) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)("Downloaded " + gav + MavenLoggingResolutionEventListener.pomContaining(containing)));
        }
    }

    public void downloadError(GroupArtifactVersion gav, List<String> attemptedUris, @Nullable Pom containing) {
        StringBuilder sb = new StringBuilder("Failed to download " + gav + MavenLoggingResolutionEventListener.pomContaining(containing) + ". Attempted URIs:");
        attemptedUris.forEach(uri -> sb.append("\n  - ").append((String)uri));
        this.logger.warn((CharSequence)sb);
    }

    public void repositoryAccessFailed(String uri, Throwable e) {
        this.logger.warn((CharSequence)("Failed to access maven repository " + uri), e);
    }

    private static String pomContaining(@Nullable Pom containing) {
        return containing != null ? " from " + containing.getGav() : "";
    }

    private static String pomContaining(@Nullable ResolvedPom containing) {
        return containing != null ? " from " + containing.getGav() : "";
    }
}

