/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRun;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.config.CompositeRecipe;
import org.openrewrite.config.DeclarativeRecipe;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.InMemoryLargeSourceSet;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.style.Autodetect;
import org.openrewrite.java.tree.J;
import org.openrewrite.kotlin.style.Autodetect;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Generated;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.marker.Markup;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.AbstractRewriteMojo;
import org.openrewrite.maven.MavenMojoProjectParser;
import org.openrewrite.maven.MeterRegistryProvider;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.xml.style.Autodetect;
import org.openrewrite.xml.tree.Xml;

public abstract class AbstractRewriteBaseRunMojo
extends AbstractRewriteMojo {
    @Parameter(property="rewrite.exportDatatables", defaultValue="false")
    protected boolean exportDatatables;
    @Parameter(property="rewrite.options")
    protected @Nullable LinkedHashSet<String> options;

    protected Path repositoryRoot() {
        Path buildRoot;
        Path maybeBaseDir;
        for (maybeBaseDir = buildRoot = this.getBuildRoot(); maybeBaseDir != null && !Files.exists(maybeBaseDir.resolve(".git"), new LinkOption[0]); maybeBaseDir = maybeBaseDir.getParent()) {
        }
        if (maybeBaseDir == null) {
            return buildRoot;
        }
        return maybeBaseDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResultsContainer listResults(ExecutionContext ctx) throws MojoExecutionException {
        try (MeterRegistryProvider meterRegistryProvider = new MeterRegistryProvider(this.getLog(), this.metricsUri, this.metricsUsername, this.metricsPassword);){
            Environment env;
            Recipe recipe;
            Metrics.addRegistry((MeterRegistry)meterRegistryProvider.registry());
            Path repositoryRoot = this.repositoryRoot();
            this.getLog().info((CharSequence)String.format("Using active recipe(s) %s", this.getActiveRecipes()));
            this.getLog().info((CharSequence)String.format("Using active styles(s) %s", this.getActiveStyles()));
            if (this.getActiveRecipes().isEmpty()) {
                ResultsContainer resultsContainer = new ResultsContainer(repositoryRoot, Collections.emptyList());
                return resultsContainer;
            }
            URLClassLoader recipeArtifactCoordinatesClassloader = this.getRecipeArtifactCoordinatesClassloader();
            if (recipeArtifactCoordinatesClassloader != null) {
                this.merge(((Object)((Object)this)).getClass().getClassLoader(), recipeArtifactCoordinatesClassloader);
            }
            if ((recipe = (env = this.environment(recipeArtifactCoordinatesClassloader)).activateRecipes(this.getActiveRecipes())).getName().equals("org.openrewrite.Recipe$Noop")) {
                this.getLog().warn((CharSequence)"No recipes were activated. Activate a recipe with <activeRecipes><recipe>com.fully.qualified.RecipeClassName</recipe></activeRecipes> in this plugin's <configuration> in your pom.xml, or on the command line with -Drewrite.activeRecipes=com.fully.qualified.RecipeClassName");
                ResultsContainer resultsContainer = new ResultsContainer(repositoryRoot, Collections.emptyList());
                return resultsContainer;
            }
            if (this.options != null && !this.options.isEmpty()) {
                AbstractRewriteBaseRunMojo.configureRecipeOptions(recipe, this.options);
            }
            this.getLog().info((CharSequence)"Validating active recipes...");
            ArrayList validations = new ArrayList();
            recipe.validateAll(ctx, validations);
            List<Validated.Invalid> failedValidations = validations.stream().map(Validated::failures).flatMap(Collection::stream).collect(Collectors.toList());
            if (!failedValidations.isEmpty()) {
                failedValidations.forEach(failedValidation -> this.getLog().error((CharSequence)("Recipe validation error in " + failedValidation.getProperty() + ": " + failedValidation.getMessage()), failedValidation.getException()));
                if (this.failOnInvalidActiveRecipes) {
                    throw new MojoExecutionException("Recipe validation errors detected as part of one or more activeRecipe(s). Please check error logs.");
                }
                this.getLog().error((CharSequence)"Recipe validation errors detected as part of one or more activeRecipe(s). Execution will continue regardless.");
            }
            LargeSourceSet sourceSet = this.loadSourceSet(repositoryRoot, env, ctx);
            List<Result> results = this.runRecipe(recipe, sourceSet, ctx);
            Metrics.removeRegistry((MeterRegistry)meterRegistryProvider.registry());
            ResultsContainer resultsContainer = new ResultsContainer(repositoryRoot, results);
            return resultsContainer;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Dependency resolution required", (Exception)((Object)e));
        }
    }

    private static void configureRecipeOptions(Recipe recipe, Set<String> options) throws MojoExecutionException {
        if (recipe instanceof CompositeRecipe || recipe instanceof DeclarativeRecipe || recipe instanceof Recipe.DelegatingRecipe || !recipe.getRecipeList().isEmpty()) {
            throw new MojoExecutionException("Recipes containing other recipes can not be configured from the command line: " + recipe);
        }
        HashMap<String, String> optionValues = new HashMap<String, String>();
        for (String option : options) {
            String[] parts = option.split("=", 2);
            if (parts.length != 2) continue;
            optionValues.put(parts[0], parts[1]);
        }
        for (Field field : recipe.getClass().getDeclaredFields()) {
            String removed = (String)optionValues.remove(field.getName());
            AbstractRewriteBaseRunMojo.updateOption(recipe, field, removed);
        }
        if (!optionValues.isEmpty()) {
            throw new MojoExecutionException(String.format("Unknown recipe options: %s", String.join((CharSequence)", ", optionValues.keySet())));
        }
    }

    private static void updateOption(Recipe recipe, Field field, @Nullable String optionValue) throws MojoExecutionException {
        Object convertedOptionValue = AbstractRewriteBaseRunMojo.convertOptionValue(field.getName(), optionValue, field.getType());
        if (convertedOptionValue == null) {
            return;
        }
        try {
            field.setAccessible(true);
            field.set(recipe, convertedOptionValue);
            field.setAccessible(false);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new MojoExecutionException(String.format("Unable to configure recipe '%s' option '%s' with value '%s'", recipe.getClass().getSimpleName(), field.getName(), optionValue));
        }
    }

    private static @Nullable Object convertOptionValue(String name, @Nullable String optionValue, Class<?> type) throws MojoExecutionException {
        if (optionValue == null) {
            return null;
        }
        if (type.isAssignableFrom(String.class)) {
            return optionValue;
        }
        if (type.isAssignableFrom(Boolean.TYPE) || type.isAssignableFrom(Boolean.class)) {
            return Boolean.parseBoolean(optionValue);
        }
        if (type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class)) {
            return Integer.parseInt(optionValue);
        }
        if (type.isAssignableFrom(Long.TYPE) || type.isAssignableFrom(Long.class)) {
            return Long.parseLong(optionValue);
        }
        throw new MojoExecutionException(String.format("Unable to convert option: %s value: %s to type: %s", name, optionValue, type));
    }

    protected LargeSourceSet loadSourceSet(Path repositoryRoot, Environment env, ExecutionContext ctx) throws DependencyResolutionRequiredException, MojoExecutionException {
        List<NamedStyles> styles = this.loadStyles(this.project, env);
        MavenMojoProjectParser projectParser = new MavenMojoProjectParser(this.getLog(), repositoryRoot, this.pomCacheEnabled, this.pomCacheDirectory, this.runtime, this.skipMavenParsing, this.getExclusions(), this.getPlainTextMasks(), this.sizeThresholdMb, this.mavenSession, this.settingsDecrypter, this.runPerSubmodule, true);
        Stream<SourceFile> sourceFiles = projectParser.listSourceFiles(this.project, styles, ctx);
        List<SourceFile> sourceFileList = this.sourcesWithAutoDetectedStyles(sourceFiles);
        return new InMemoryLargeSourceSet(sourceFileList);
    }

    protected List<Result> runRecipe(Recipe recipe, LargeSourceSet sourceSet, ExecutionContext ctx) {
        this.getLog().info((CharSequence)"Running recipe(s)...");
        RecipeRun recipeRun = recipe.run(sourceSet, ctx);
        if (this.exportDatatables) {
            String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss-SSS"));
            Path datatableDirectoryPath = Paths.get("target", "rewrite", "datatables", timestamp);
            this.getLog().info((CharSequence)String.format("Printing available datatables to: %s", datatableDirectoryPath));
            recipeRun.exportDatatablesToCsv(datatableDirectoryPath, ctx);
        }
        return recipeRun.getChangeset().getAllResults().stream().filter(source -> {
            if (source.getBefore() != null) {
                return !source.getBefore().getMarkers().findFirst(Generated.class).isPresent();
            }
            return true;
        }).collect(Collectors.toList());
    }

    private List<SourceFile> sourcesWithAutoDetectedStyles(Stream<SourceFile> sourceFiles) {
        Autodetect.Detector javaDetector = Autodetect.detector();
        Autodetect.Detector kotlinDetector = org.openrewrite.kotlin.style.Autodetect.detector();
        Autodetect.Detector xmlDetector = org.openrewrite.xml.style.Autodetect.detector();
        List sourceFileList = sourceFiles.peek(s -> {
            if (s instanceof K.CompilationUnit) {
                kotlinDetector.sample(s);
            } else if (s instanceof J.CompilationUnit) {
                javaDetector.sample(s);
            }
        }).peek(arg_0 -> ((Autodetect.Detector)xmlDetector).sample(arg_0)).collect(Collectors.toList());
        HashMap<Class<? extends Tree>, NamedStyles> stylesByType = new HashMap<Class<? extends Tree>, NamedStyles>();
        stylesByType.put((Class<? extends Tree>)J.CompilationUnit.class, (NamedStyles)javaDetector.build());
        stylesByType.put((Class<? extends Tree>)K.CompilationUnit.class, (NamedStyles)kotlinDetector.build());
        stylesByType.put((Class<? extends Tree>)Xml.Document.class, (NamedStyles)xmlDetector.build());
        return ListUtils.map(sourceFileList, this.applyAutodetectedStyle(stylesByType));
    }

    private UnaryOperator<SourceFile> applyAutodetectedStyle(Map<Class<? extends Tree>, NamedStyles> stylesByType) {
        return before -> {
            for (Map.Entry styleTypeEntry : stylesByType.entrySet()) {
                if (!((Class)styleTypeEntry.getKey()).isAssignableFrom(before.getClass())) continue;
                before = (SourceFile)before.withMarkers(before.getMarkers().add((Marker)styleTypeEntry.getValue()));
            }
            return before;
        };
    }

    private void merge(ClassLoader targetClassLoader, URLClassLoader sourceClassLoader) {
        ClassRealm targetClassRealm;
        try {
            targetClassRealm = (ClassRealm)targetClassLoader;
        }
        catch (ClassCastException e) {
            this.getLog().warn((CharSequence)"Could not merge ClassLoaders due to unexpected targetClassLoader type", (Throwable)e);
            return;
        }
        HashSet<String> existingVersionlessJars = new HashSet<String>();
        for (URL existingUrl : targetClassRealm.getURLs()) {
            existingVersionlessJars.add(this.stripVersion(existingUrl));
        }
        for (URL newUrl : sourceClassLoader.getURLs()) {
            if (existingVersionlessJars.contains(this.stripVersion(newUrl))) continue;
            targetClassRealm.addURL(newUrl);
        }
    }

    private String stripVersion(URL jarUrl) {
        return jarUrl.toString().replaceAll("/[^/]+/[^/]+\\.jar", "");
    }

    protected void logRecipesThatMadeChanges(Result result) {
        String indent = "    ";
        String prefix = "    ";
        for (RecipeDescriptor recipeDescriptor : result.getRecipeDescriptorsThatMadeChanges()) {
            this.logRecipe(recipeDescriptor, prefix);
            prefix = prefix + indent;
        }
    }

    private void logRecipe(RecipeDescriptor rd, String prefix) {
        String opts;
        StringBuilder recipeString = new StringBuilder(prefix + rd.getName());
        if (!rd.getOptions().isEmpty() && !(opts = rd.getOptions().stream().map(option -> {
            if (option.getValue() != null) {
                return option.getName() + "=" + option.getValue();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.joining(", "))).isEmpty()) {
            recipeString.append(": {").append(opts).append("}");
        }
        this.getLog().warn((CharSequence)recipeString.toString());
        for (RecipeDescriptor rchild : rd.getRecipeList()) {
            this.logRecipe(rchild, prefix + "    ");
        }
    }

    protected Duration estimateTimeSavedSum(Result result, Duration timeSaving) {
        if (null != result.getTimeSavings()) {
            return timeSaving.plus(result.getTimeSavings());
        }
        return timeSaving;
    }

    protected String formatDuration(Duration duration) {
        return duration.toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase().trim();
    }

    public static class ResultsContainer {
        final Path projectRoot;
        final List<Result> generated = new ArrayList<Result>();
        final List<Result> deleted = new ArrayList<Result>();
        final List<Result> moved = new ArrayList<Result>();
        final List<Result> refactoredInPlace = new ArrayList<Result>();

        public ResultsContainer(Path projectRoot, Collection<Result> results) {
            this.projectRoot = projectRoot;
            for (Result result : results) {
                if (result.getBefore() == null && result.getAfter() == null) continue;
                if (result.getBefore() == null && result.getAfter() != null) {
                    this.generated.add(result);
                    continue;
                }
                if (result.getBefore() != null && result.getAfter() == null) {
                    this.deleted.add(result);
                    continue;
                }
                if (result.getBefore() != null && result.getAfter() != null && !result.getBefore().getSourcePath().equals(result.getAfter().getSourcePath())) {
                    this.moved.add(result);
                    continue;
                }
                if (result.diff(Paths.get("", new String[0]), (PrintOutputCapture.MarkerPrinter)new FencedMarkerPrinter(), Boolean.valueOf(true)).isEmpty()) continue;
                this.refactoredInPlace.add(result);
            }
        }

        public @Nullable RuntimeException getFirstException() {
            Iterator<RuntimeException> iterator;
            for (Result result : this.generated) {
                iterator = this.getRecipeErrors(result).iterator();
                if (!iterator.hasNext()) continue;
                RuntimeException error = iterator.next();
                return error;
            }
            for (Result result : this.deleted) {
                iterator = this.getRecipeErrors(result).iterator();
                if (!iterator.hasNext()) continue;
                RuntimeException error = iterator.next();
                return error;
            }
            for (Result result : this.moved) {
                iterator = this.getRecipeErrors(result).iterator();
                if (!iterator.hasNext()) continue;
                RuntimeException error = iterator.next();
                return error;
            }
            for (Result result : this.refactoredInPlace) {
                iterator = this.getRecipeErrors(result).iterator();
                if (!iterator.hasNext()) continue;
                RuntimeException error = iterator.next();
                return error;
            }
            return null;
        }

        private List<RuntimeException> getRecipeErrors(Result result) {
            final ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
            new TreeVisitor<Tree, Integer>(){

                public Tree preVisit(Tree tree, Integer integer) {
                    Markers markers = tree.getMarkers();
                    markers.findFirst(Markup.Error.class).ifPresent(e -> {
                        Optional<SourceFile> sourceFile = Optional.ofNullable((SourceFile)this.getCursor().firstEnclosing(SourceFile.class));
                        String sourcePath = sourceFile.map(SourceFile::getSourcePath).map(Path::toString).orElse("<unknown>");
                        exceptions.add(new RuntimeException("Error while visiting " + sourcePath + ": " + e.getDetail()));
                    });
                    return tree;
                }
            }.visit((Tree)result.getAfter(), (Object)0);
            return exceptions;
        }

        public Path getProjectRoot() {
            return this.projectRoot;
        }

        public boolean isNotEmpty() {
            return !this.generated.isEmpty() || !this.deleted.isEmpty() || !this.moved.isEmpty() || !this.refactoredInPlace.isEmpty();
        }

        public List<Path> newlyEmptyDirectories() {
            LinkedHashSet<Path> maybeEmptyDirectories = new LinkedHashSet<Path>();
            for (Result result : this.moved) {
                assert (result.getBefore() != null);
                maybeEmptyDirectories.add(this.projectRoot.resolve(result.getBefore().getSourcePath()).getParent());
            }
            for (Result result : this.deleted) {
                assert (result.getBefore() != null);
                maybeEmptyDirectories.add(this.projectRoot.resolve(result.getBefore().getSourcePath()).getParent());
            }
            if (maybeEmptyDirectories.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Path> emptyDirectories = new ArrayList<Path>(maybeEmptyDirectories.size());
            for (Path maybeEmptyDirectory : maybeEmptyDirectories) {
                try {
                    Stream<Path> contents = Files.list(maybeEmptyDirectory);
                    try {
                        if (contents.findAny().isPresent()) continue;
                        Files.delete(maybeEmptyDirectory);
                    }
                    finally {
                        if (contents == null) continue;
                        contents.close();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return emptyDirectories;
        }

        private static class FencedMarkerPrinter
        implements PrintOutputCapture.MarkerPrinter {
            private FencedMarkerPrinter() {
            }

            public String beforeSyntax(Marker marker, Cursor cursor, UnaryOperator<String> commentWrapper) {
                return marker instanceof SearchResult || marker instanceof Markup ? "{{" + marker.getId() + "}}" : "";
            }

            public String afterSyntax(Marker marker, Cursor cursor, UnaryOperator<String> commentWrapper) {
                return marker instanceof SearchResult || marker instanceof Markup ? "{{" + marker.getId() + "}}" : "";
            }
        }
    }
}

