/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.config.ClasspathScanningLoader;
import org.openrewrite.config.Environment;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.ipc.http.HttpUrlConnectionSender;
import org.openrewrite.maven.ArtifactResolver;
import org.openrewrite.maven.ConfigurableRewriteMojo;

public abstract class AbstractRewriteMojo
extends ConfigurableRewriteMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="rewrite.resolvePropertiesInYaml", defaultValue="true")
    protected boolean resolvePropertiesInYaml;
    @Component
    protected RuntimeInformation runtime;
    @Component
    protected SettingsDecrypter settingsDecrypter;
    @Component
    protected RepositorySystem repositorySystem;

    protected Environment environment() throws MojoExecutionException {
        return this.environment(this.getRecipeArtifactCoordinatesClassloader());
    }

    @Nullable Config getConfig() throws IOException {
        File rewriteConfig;
        try {
            URI uri = new URI(this.configLocation);
            if (uri.getScheme() != null && uri.getScheme().startsWith("http")) {
                HttpUrlConnectionSender httpSender = new HttpUrlConnectionSender();
                return new Config(httpSender.get(this.configLocation).send().getBody(), uri);
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        Path absoluteConfigLocation = Paths.get(this.configLocation, new String[0]);
        if (!absoluteConfigLocation.isAbsolute()) {
            absoluteConfigLocation = this.project.getBasedir().toPath().resolve(this.configLocation);
        }
        if ((rewriteConfig = absoluteConfigLocation.toFile()).exists()) {
            return new Config(Files.newInputStream(rewriteConfig.toPath(), new OpenOption[0]), rewriteConfig.toURI());
        }
        this.getLog().debug((CharSequence)("No rewrite configuration found at " + absoluteConfigLocation));
        return null;
    }

    protected Environment environment(@Nullable ClassLoader recipeClassLoader) throws MojoExecutionException {
        Environment.Builder env;
        block10: {
            env = Environment.builder((Properties)this.project.getProperties());
            if (recipeClassLoader == null) {
                env.scanRuntimeClasspath(new String[0]).scanUserHome();
            } else {
                env.load((ResourceLoader)new ClasspathScanningLoader(this.project.getProperties(), recipeClassLoader));
            }
            try {
                Config rewriteConfig = this.getConfig();
                if (rewriteConfig == null) break block10;
                try (InputStream is = rewriteConfig.inputStream;){
                    Properties propertiesToResolve = this.resolvePropertiesInYaml ? this.project.getProperties() : new Properties();
                    env.load((ResourceLoader)new YamlResourceLoader(is, rewriteConfig.uri, propertiesToResolve));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to load rewrite configuration", (Exception)e);
            }
        }
        return env.build();
    }

    protected ExecutionContext executionContext() {
        return new InMemoryExecutionContext(t -> this.getLog().debug(t));
    }

    protected Path getBuildRoot() {
        Path localRepositoryFolder = Paths.get(this.mavenSession.getLocalRepository().getBasedir(), new String[0]).normalize();
        HashSet<Path> baseFolders = new HashSet<Path>();
        for (MavenProject project : this.mavenSession.getAllProjects()) {
            this.collectBasePaths(project, baseFolders, localRepositoryFolder);
        }
        if (!baseFolders.isEmpty()) {
            ArrayList sortedPaths = new ArrayList(baseFolders);
            Collections.sort(sortedPaths);
            return (Path)sortedPaths.get(0);
        }
        return Paths.get(this.mavenSession.getExecutionRootDirectory(), new String[0]);
    }

    private void collectBasePaths(MavenProject project, Set<Path> paths, Path localRepository) {
        Path baseDir;
        Path path = baseDir = project.getBasedir() == null ? null : project.getBasedir().toPath().normalize();
        if (baseDir == null || baseDir.startsWith(localRepository) || paths.contains(baseDir)) {
            return;
        }
        paths.add(baseDir);
        for (MavenProject parent = project.getParent(); parent != null && parent.getBasedir() != null; parent = parent.getParent()) {
            this.collectBasePaths(parent, paths, localRepository);
        }
    }

    protected @Nullable URLClassLoader getRecipeArtifactCoordinatesClassloader() throws MojoExecutionException {
        if (this.getRecipeArtifactCoordinates().isEmpty()) {
            return null;
        }
        ArtifactResolver resolver = new ArtifactResolver(this.repositorySystem, this.mavenSession);
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        for (String coordinate : this.getRecipeArtifactCoordinates()) {
            artifacts.add(resolver.createArtifact(coordinate));
        }
        Set<Artifact> resolvedArtifacts = resolver.resolveArtifactsAndDependencies(artifacts);
        URL[] urls = (URL[])resolvedArtifacts.stream().map(Artifact::getFile).map(File::toURI).map(uri -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Failed to resolve artifacts from rewrite.recipeArtifactCoordinates", e);
            }
        }).toArray(URL[]::new);
        return new URLClassLoader(urls, AbstractRewriteMojo.class.getClassLoader());
    }

    static class Config {
        final InputStream inputStream;
        final URI uri;

        Config(InputStream inputStream, URI uri) {
            this.inputStream = inputStream;
            this.uri = uri;
        }
    }
}

