/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.dataflow;

import java.util.Optional;
import java.util.function.Function;
import org.openrewrite.Cursor;
import org.openrewrite.analysis.dataflow.ExpressionDataFlowNode;
import org.openrewrite.analysis.dataflow.ParameterDataFlowNode;
import org.openrewrite.analysis.trait.expr.Expr;
import org.openrewrite.analysis.trait.expr.ExprParent;
import org.openrewrite.analysis.trait.util.TraitErrors;
import org.openrewrite.analysis.trait.variable.Parameter;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public abstract class DataFlowNode {
    final Cursor cursor;

    public abstract Optional<Expr> asExpr();

    public <E extends Expr> Optional<E> asExpr(Class<E> clazz) {
        return this.asExpr().filter(clazz::isInstance).map(clazz::cast);
    }

    public <E extends ExprParent> Optional<E> asExprParent(Class<E> clazz) {
        return this.asExpr().filter(clazz::isInstance).map(clazz::cast);
    }

    abstract Optional<Parameter> asParameter();

    abstract <T> T map(Function<Expr, T> var1, Function<Parameter, T> var2);

    public static DataFlowNode of(Cursor cursor) {
        if (cursor.getValue() instanceof Expression) {
            return new ExpressionDataFlowNode(cursor, (Expr)Expr.viewOf(cursor).on(TraitErrors::doThrow));
        }
        if (cursor.getValue() instanceof J.VariableDeclarations.NamedVariable) {
            return new ParameterDataFlowNode(cursor, (Parameter)Parameter.viewOf(cursor).on(TraitErrors::doThrow));
        }
        throw new IllegalArgumentException("DataFlowNode can not be of type: " + cursor.getValue().getClass());
    }

    DataFlowNode(Cursor cursor) {
        this.cursor = cursor;
    }

    public Cursor getCursor() {
        return this.cursor;
    }
}

