/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.trait.variable;

import fj.data.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.openrewrite.Cursor;
import org.openrewrite.analysis.trait.Top;
import org.openrewrite.analysis.trait.expr.Expr;
import org.openrewrite.analysis.trait.expr.VarAccess;
import org.openrewrite.analysis.trait.member.Method;
import org.openrewrite.analysis.trait.variable.Parameter;
import org.openrewrite.analysis.trait.variable.VariableUtil;
import org.openrewrite.analysis.util.FlagUtil;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

class ParameterBase
extends Top.Base
implements Parameter {
    private final Cursor cursor;
    private final J.VariableDeclarations.NamedVariable namedVariable;
    private final J.VariableDeclarations variableDeclarations;
    private final Method callable;
    private final Cursor methodDeclarationCursor;
    private final J.MethodDeclaration methodDeclaration;

    @Override
    public UUID getId() {
        return this.namedVariable.getId();
    }

    @Override
    public String getName() {
        return this.namedVariable.getSimpleName();
    }

    @Override
    public int getPosition() {
        return this.callable.getParameters().indexOf(this);
    }

    @Override
    public boolean isVarArgs() {
        if (this.namedVariable.getVariableType() == null) {
            throw new IllegalStateException("Variable type is null for " + this.namedVariable);
        }
        return this.namedVariable.getVariableType().hasFlags(new Flag[]{Flag.Varargs});
    }

    @Override
    public Option<JavaType> getType() {
        return Option.fromNull((Object)this.namedVariable.getType());
    }

    @Override
    public Collection<VarAccess> getVarAccesses() {
        if (this.methodDeclaration.getBody() == null) {
            return Collections.emptySet();
        }
        return VarAccess.findAllInScope(new Cursor(this.methodDeclarationCursor, (Object)this.methodDeclaration.getBody()), this);
    }

    @Override
    public Collection<Expr> getAssignedValues() {
        if (this.methodDeclaration.getBody() == null) {
            return Collections.emptySet();
        }
        return VariableUtil.findAssignedValues(new Cursor(this.methodDeclarationCursor, (Object)this.methodDeclaration.getBody()), this);
    }

    @Override
    public Collection<Flag> getFlags() {
        return FlagUtil.fromModifiers(this.variableDeclarations.getModifiers());
    }

    public ParameterBase(Cursor cursor, J.VariableDeclarations.NamedVariable namedVariable, J.VariableDeclarations variableDeclarations, Method callable, Cursor methodDeclarationCursor, J.MethodDeclaration methodDeclaration) {
        this.cursor = cursor;
        this.namedVariable = namedVariable;
        this.variableDeclarations = variableDeclarations;
        this.callable = callable;
        this.methodDeclarationCursor = methodDeclarationCursor;
        this.methodDeclaration = methodDeclaration;
    }

    @Override
    public Method getCallable() {
        return this.callable;
    }
}

