/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai.table;

import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class TopKMethodMatcher
extends DataTable<Row> {
    public TopKMethodMatcher(Recipe recipe) {
        super(recipe, "Top-K Method Matcher", "Result from the scanning recipe for top-k method patterns that match the query.");
    }

    public static final class Row {
        @Column(displayName="Method Pattern", description="Method invocation pattern.")
        private final String methodPattern;
        @Column(displayName="Method Signature", description="Method invocation signature.")
        private final String methodSignature;
        @Column(displayName="Distance", description="The distance between the query and the method invocation.")
        private final double distance;
        @Column(displayName="Query", description="The natural language search query.")
        private final String query;

        @Generated
        public Row(String methodPattern, String methodSignature, double distance, String query) {
            this.methodPattern = methodPattern;
            this.methodSignature = methodSignature;
            this.distance = distance;
            this.query = query;
        }

        @Generated
        public String getMethodPattern() {
            return this.methodPattern;
        }

        @Generated
        public String getMethodSignature() {
            return this.methodSignature;
        }

        @Generated
        public double getDistance() {
            return this.distance;
        }

        @Generated
        public String getQuery() {
            return this.query;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (Double.compare(this.getDistance(), other.getDistance()) != 0) {
                return false;
            }
            String this$methodPattern = this.getMethodPattern();
            String other$methodPattern = other.getMethodPattern();
            if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
                return false;
            }
            String this$methodSignature = this.getMethodSignature();
            String other$methodSignature = other.getMethodSignature();
            if (this$methodSignature == null ? other$methodSignature != null : !this$methodSignature.equals(other$methodSignature)) {
                return false;
            }
            String this$query = this.getQuery();
            String other$query = other.getQuery();
            return !(this$query == null ? other$query != null : !this$query.equals(other$query));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $distance = Double.doubleToLongBits(this.getDistance());
            result = result * 59 + (int)($distance >>> 32 ^ $distance);
            String $methodPattern = this.getMethodPattern();
            result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
            String $methodSignature = this.getMethodSignature();
            result = result * 59 + ($methodSignature == null ? 43 : $methodSignature.hashCode());
            String $query = this.getQuery();
            result = result * 59 + ($query == null ? 43 : $query.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TopKMethodMatcher.Row(methodPattern=" + this.getMethodPattern() + ", methodSignature=" + this.getMethodSignature() + ", distance=" + this.getDistance() + ", query=" + this.getQuery() + ")";
        }
    }
}

