/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai;

import io.moderne.ai.LanguageDetectorModelClient;
import io.moderne.ai.table.LanguageDistribution;
import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public final class FindCommentsLanguage
extends Recipe {
    private final transient LanguageDistribution distribution = new LanguageDistribution(this);

    public String getDisplayName() {
        return "Find comments' language distribution";
    }

    public String getDescription() {
        return "Finds all comments and uses AI to predict which language the comment is in.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public Space visitSpace(Space space, Space.Location loc, ExecutionContext ctx) {
                return space.withComments(ListUtils.map((List)space.getComments(), comment -> {
                    if (comment instanceof TextComment) {
                        JavaSourceFile javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                        FindCommentsLanguage.this.distribution.insertRow(ctx, new LanguageDistribution.Row(javaSourceFile.getSourcePath().toString(), ((TextComment)comment).getText(), LanguageDetectorModelClient.getInstance().getLanguage(((TextComment)comment).getText()).getLanguage()));
                        return comment.withMarkers(comment.getMarkers().computeByType((Marker)new SearchResult(Tree.randomId(), null), (s1, s2) -> s1 == null ? s2 : s1));
                    }
                    return comment;
                }));
            }
        };
    }

    @Generated
    public FindCommentsLanguage() {
    }

    @Generated
    public LanguageDistribution getDistribution() {
        return this.distribution;
    }

    @Generated
    public String toString() {
        return "FindCommentsLanguage(distribution=" + (Object)((Object)this.getDistribution()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindCommentsLanguage)) {
            return false;
        }
        FindCommentsLanguage other = (FindCommentsLanguage)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindCommentsLanguage;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

