/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai;

import io.moderne.ai.LanguageDetectorModelClient;
import io.moderne.ai.SpellCheckerClient;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public final class SpellCheckCommentsInFrenchPomXml
extends Recipe {
    public String getDisplayName() {
        return "Fix mis-encoded comments in French in pom.xml files";
    }

    public String getDescription() {
        return "Use spellchecker to fix mis-encoded French comments in pom.xml files. Mis-encoded comments will contain either '?' or '\ufffd'.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            public Xml.Comment visitComment(Xml.Comment comment, ExecutionContext ctx) {
                String fixedComment;
                String commentText = comment.getText();
                if (!commentText.isEmpty() && "fr".equals(LanguageDetectorModelClient.getInstance().getLanguage(commentText).getLanguage()) && !(fixedComment = SpellCheckerClient.getInstance().getCommentGradio(commentText)).equals(commentText)) {
                    return comment.withText(fixedComment);
                }
                return comment;
            }
        };
    }

    @Generated
    public SpellCheckCommentsInFrenchPomXml() {
    }

    @Generated
    public String toString() {
        return "SpellCheckCommentsInFrenchPomXml()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpellCheckCommentsInFrenchPomXml)) {
            return false;
        }
        SpellCheckCommentsInFrenchPomXml other = (SpellCheckCommentsInFrenchPomXml)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpellCheckCommentsInFrenchPomXml;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

