/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.ai.research;

import io.moderne.ai.EmbeddingModelClient;
import io.moderne.ai.table.Embeddings;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public final class GetCodeEmbedding
extends Recipe {
    @Option(displayName="Code snippet type", description="Choose whether you want to get an embedding for the classes or methods.", example="methods", valid={"methods", "classes"})
    private final String codeSnippetType;
    private final transient Embeddings embeddings = new Embeddings(this);

    public String getDisplayName() {
        return "Get embeddings for code snippets in code";
    }

    public String getDescription() {
        return "This recipe calls an AI model to get an embedding for either classes or methods which can then be used for downstream tasks.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        if ("methods".equals(this.codeSnippetType)) {
            return new JavaIsoVisitor<ExecutionContext>(){

                public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                    J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                    JavaSourceFile javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                    float[] embedding = EmbeddingModelClient.getInstance().getEmbedding(md.printTrimmed(this.getCursor()));
                    GetCodeEmbedding.this.embeddings.insertRow(ctx, new Embeddings.Row(javaSourceFile.getSourcePath().toString(), md.getSimpleName(), embedding));
                    return md;
                }
            };
        }
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration clazz, ExecutionContext ctx) {
                J.ClassDeclaration cd = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                JavaSourceFile javaSourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                float[] embedding = EmbeddingModelClient.getInstance().getEmbedding(cd.printTrimmed(this.getCursor()));
                GetCodeEmbedding.this.embeddings.insertRow(ctx, new Embeddings.Row(javaSourceFile.getSourcePath().toString(), cd.getSimpleName(), embedding));
                return cd;
            }
        };
    }

    @Generated
    public GetCodeEmbedding(String codeSnippetType) {
        this.codeSnippetType = codeSnippetType;
    }

    @Generated
    public String getCodeSnippetType() {
        return this.codeSnippetType;
    }

    @Generated
    public Embeddings getEmbeddings() {
        return this.embeddings;
    }

    @Generated
    public String toString() {
        return "GetCodeEmbedding(codeSnippetType=" + this.getCodeSnippetType() + ", embeddings=" + (Object)((Object)this.getEmbeddings()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetCodeEmbedding)) {
            return false;
        }
        GetCodeEmbedding other = (GetCodeEmbedding)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$codeSnippetType = this.getCodeSnippetType();
        String other$codeSnippetType = other.getCodeSnippetType();
        return !(this$codeSnippetType == null ? other$codeSnippetType != null : !this$codeSnippetType.equals(other$codeSnippetType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GetCodeEmbedding;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $codeSnippetType = this.getCodeSnippetType();
        result = result * 59 + ($codeSnippetType == null ? 43 : $codeSnippetType.hashCode());
        return result;
    }
}

