/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.Markup;
import org.openrewrite.table.CallGraph;

public final class FindCallGraph
extends Recipe {
    private final transient CallGraph callGraph = new CallGraph(this);
    @Option(displayName="Include standard library", description="When enabled calls to methods in packages beginning with \"java\", \"groovy\", and \"kotlin\" will be included in the report. By default these are omitted.", required=false)
    private final boolean includeStdLib;

    public String getDisplayName() {
        return "Find call graph";
    }

    public String getDescription() {
        return "Produces a data table where each row represents a method call.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (classDecl.getType() == null) {
                    return (J.ClassDeclaration)Markup.warn((Tree)classDecl, (Throwable)new IllegalStateException("Class declaration is missing type attribution"));
                }
                return super.visitClassDeclaration(classDecl, (Object)ctx);
            }

            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                return super.visitNewClass(this.recordCall(newClass, ctx), (Object)ctx);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                return super.visitMethodInvocation(this.recordCall(method, ctx), (Object)ctx);
            }

            public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext ctx) {
                return super.visitMemberReference(this.recordCall(memberRef, ctx), (Object)ctx);
            }

            private <T extends J> T recordCall(T j, ExecutionContext ctx) {
                Set methodsCalledInScope;
                JavaType.Method method = null;
                if (j instanceof J.MethodInvocation) {
                    method = ((J.MethodInvocation)j).getMethodType();
                } else if (j instanceof J.NewClass) {
                    method = ((J.NewClass)j).getMethodType();
                } else if (j instanceof J.MemberReference) {
                    method = ((J.MemberReference)j).getMethodType();
                }
                if (method == null) {
                    return (T)((J)Markup.warn(j, (Throwable)new IllegalStateException("Method type not found")));
                }
                String fqn = method.getDeclaringType().getFullyQualifiedName();
                if (!FindCallGraph.this.includeStdLib && (fqn.startsWith("java.") || fqn.startsWith("groovy.") || fqn.startsWith("kotlin."))) {
                    return j;
                }
                Cursor scope = this.getCursor().dropParentUntil(it -> it instanceof J.MethodDeclaration || it instanceof J.ClassDeclaration || it instanceof SourceFile);
                if (scope.getValue() instanceof J.ClassDeclaration) {
                    boolean isInStaticInitializer = this.inStaticInitializer();
                    if (isInStaticInitializer && ((HashSet)scope.computeMessageIfAbsent("METHODS_CALLED_IN_STATIC_INITIALIZATION", k -> new HashSet())).add(method) || !isInStaticInitializer && ((HashSet)scope.computeMessageIfAbsent("METHODS_CALLED_IN_INSTANCE_INITIALIZATION", k -> new HashSet())).add(method)) {
                        FindCallGraph.this.callGraph.insertRow(ctx, this.row(Objects.requireNonNull(((J.ClassDeclaration)scope.getValue()).getType()).getFullyQualifiedName(), method));
                    }
                } else if (scope.getValue() instanceof J.MethodDeclaration) {
                    Set methodsCalledInScope2 = (Set)scope.computeMessageIfAbsent("METHODS_CALLED_IN_SCOPE", k -> new HashSet());
                    if (methodsCalledInScope2.add(method)) {
                        FindCallGraph.this.callGraph.insertRow(ctx, this.row(Objects.requireNonNull(((J.MethodDeclaration)scope.getValue()).getMethodType()), method));
                    }
                } else if (scope.getValue() instanceof SourceFile && (methodsCalledInScope = (Set)scope.computeMessageIfAbsent("METHODS_CALLED_IN_SCOPE", k -> new HashSet())).add(method)) {
                    FindCallGraph.this.callGraph.insertRow(ctx, this.row(((SourceFile)scope.getValue()).getSourcePath().toString(), method));
                }
                return j;
            }

            private boolean inStaticInitializer() {
                AtomicBoolean inStaticInitializer = new AtomicBoolean();
                this.getCursor().dropParentUntil(it -> {
                    J.VariableDeclarations vd;
                    if (it instanceof SourceFile) {
                        return true;
                    }
                    if (it instanceof J.Block) {
                        J.Block b = (J.Block)it;
                        if (b.isStatic()) {
                            inStaticInitializer.set(true);
                            return true;
                        }
                    } else if (it instanceof J.VariableDeclarations && (vd = (J.VariableDeclarations)it).hasModifier(J.Modifier.Type.Static)) {
                        inStaticInitializer.set(true);
                        return true;
                    }
                    return false;
                });
                return inStaticInitializer.get();
            }

            private CallGraph.Row row(String fqn, JavaType.Method to) {
                return new CallGraph.Row(fqn, this.inStaticInitializer() ? "<clinit>" : "<init>", "", CallGraph.ResourceType.METHOD, CallGraph.ResourceAction.CALL, to.getDeclaringType().getFullyQualifiedName(), to.getName(), FindCallGraph.parameters(to), FindCallGraph.resourceType(to), FindCallGraph.returnType(to));
            }

            private CallGraph.Row row(JavaType.Method from, JavaType.Method to) {
                return new CallGraph.Row(from.getDeclaringType().getFullyQualifiedName(), from.getName(), FindCallGraph.parameters(from), FindCallGraph.resourceType(from), CallGraph.ResourceAction.CALL, to.getDeclaringType().getFullyQualifiedName(), to.getName(), FindCallGraph.parameters(to), FindCallGraph.resourceType(to), FindCallGraph.returnType(to));
            }
        };
    }

    private static String parameters(JavaType.Method method) {
        StringJoiner joiner = new StringJoiner(",");
        for (JavaType javaType : method.getParameterTypes()) {
            String string = javaType.toString();
            joiner.add(string);
        }
        return joiner.toString();
    }

    private static CallGraph.ResourceType resourceType(JavaType.Method method) {
        if (method.isConstructor()) {
            return CallGraph.ResourceType.CONSTRUCTOR;
        }
        return CallGraph.ResourceType.METHOD;
    }

    private static String returnType(JavaType.Method method) {
        return method.getReturnType().toString();
    }

    @Generated
    public FindCallGraph(boolean includeStdLib) {
        this.includeStdLib = includeStdLib;
    }

    @Generated
    public CallGraph getCallGraph() {
        return this.callGraph;
    }

    @Generated
    public boolean isIncludeStdLib() {
        return this.includeStdLib;
    }

    @Generated
    public String toString() {
        return "FindCallGraph(callGraph=" + (Object)((Object)this.getCallGraph()) + ", includeStdLib=" + this.isIncludeStdLib() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindCallGraph)) {
            return false;
        }
        FindCallGraph other = (FindCallGraph)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return this.isIncludeStdLib() == other.isIncludeStdLib();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindCallGraph;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeStdLib() ? 79 : 97);
        return result;
    }
}

