/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import java.util.Set;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

public class DuplicateSourceFiles
extends DataTable<Row> {
    public DuplicateSourceFiles(Recipe recipe) {
        super(recipe, "Duplicate source files", "A list of source files that occur more than once in an LST.");
    }

    public static final class Row {
        @Column(displayName="Source path", description="The path to the source file.")
        private final String sourcePath;
        @Column(displayName="Count", description="The number of times an LST element with this source file path is present.")
        private final int count;
        @Column(displayName="Types", description="The LST types of the source file.")
        private final Set<String> types;

        @Generated
        public Row(String sourcePath, int count, Set<String> types) {
            this.sourcePath = sourcePath;
            this.count = count;
            this.types = types;
        }

        @Generated
        public String getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public int getCount() {
            return this.count;
        }

        @Generated
        public Set<String> getTypes() {
            return this.types;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getCount() != other.getCount()) {
                return false;
            }
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            Set<String> this$types = this.getTypes();
            Set<String> other$types = other.getTypes();
            return !(this$types == null ? other$types != null : !((Object)this$types).equals(other$types));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCount();
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            Set<String> $types = this.getTypes();
            result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DuplicateSourceFiles.Row(sourcePath=" + this.getSourcePath() + ", count=" + this.getCount() + ", types=" + this.getTypes() + ")";
        }
    }
}

