/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;

@JsonIgnoreType
public class LanguageCompositionPerRepository
extends DataTable<Row> {
    public LanguageCompositionPerRepository(Recipe recipe) {
        super(recipe, "Language composition report", "Counts the number of files and lines of source code in the various formats OpenRewrite knows how to parse.");
    }

    public static final class Row {
        @Column(displayName="Language", description="Language of the source file.")
        private final String language;
        @Column(displayName="File count", description="Count of files of this language.")
        private final int fileCount;
        @Column(displayName="Line count", description="Count of lines of this language.")
        private final int lineCount;

        @Generated
        public Row(String language, int fileCount, int lineCount) {
            this.language = language;
            this.fileCount = fileCount;
            this.lineCount = lineCount;
        }

        @Generated
        public String getLanguage() {
            return this.language;
        }

        @Generated
        public int getFileCount() {
            return this.fileCount;
        }

        @Generated
        public int getLineCount() {
            return this.lineCount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getFileCount() != other.getFileCount()) {
                return false;
            }
            if (this.getLineCount() != other.getLineCount()) {
                return false;
            }
            String this$language = this.getLanguage();
            String other$language = other.getLanguage();
            return !(this$language == null ? other$language != null : !this$language.equals(other$language));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFileCount();
            result = result * 59 + this.getLineCount();
            String $language = this.getLanguage();
            result = result * 59 + ($language == null ? 43 : $language.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LanguageCompositionPerRepository.Row(language=" + this.getLanguage() + ", fileCount=" + this.getFileCount() + ", lineCount=" + this.getLineCount() + ")";
        }
    }
}

