/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.httpclient5;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class NewRequestLine
extends Recipe {
    private static final MethodMatcher MATCHER = new MethodMatcher("org.apache.hc.client5.http.classic.methods.HttpUriRequestBase getRequestLine()");

    public String getDisplayName() {
        return "Replaces deprecated `HttpRequestBase::getRequestLine()`";
    }

    public String getDescription() {
        return "`HttpRequestBase::getStatusLine()` was removed in 5.x when `HttpRequestBase` was migrated to `HttpUriRequestBase`, so we replace it with `new RequestLine(HttpRequest)`. Ideally we will try to simply method chains for `getMethod`, `getUri` and `getProtocolVersion`, but there are some scenarios where `RequestLine` object is assigned or used directly, and we need to instantiate the object.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(MATCHER), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (MATCHER.matches((MethodCall)m)) {
                    this.maybeAddImport("org.apache.hc.core5.http.message.RequestLine");
                    return JavaTemplate.builder((String)"new RequestLine(#{any(org.apache.hc.core5.http.HttpRequest)})").imports(new String[]{"org.apache.hc.core5.http.message.RequestLine"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"httpcore5"})).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replace(), new Object[]{m.getSelect()});
                }
                return m;
            }
        });
    }

    @Generated
    public NewRequestLine() {
    }

    @Generated
    public String toString() {
        return "NewRequestLine()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewRequestLine)) {
            return false;
        }
        NewRequestLine other = (NewRequestLine)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NewRequestLine;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

