/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.commons.lang;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.apache.commons.lang.RepeatableArgumentMatcher;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class ApacheCommonsStringUtilsRecipes
extends Recipe {
    public String getDisplayName() {
        return "`ApacheCommonsStringUtils` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `org.openrewrite.apache.commons.lang.ApacheCommonsStringUtils`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbbreviateRecipe(), new CapitalizeRecipe(), new DefaultStringRecipe(), new DefaultStringFallbackRecipe(), new DeleteWhitespaceRecipe(), new EqualsIgnoreCaseRecipe(), new EqualsRecipe(), new LowercaseRecipe(), new RemoveEndRecipe(), new ReplaceRecipe(), new ReverseRecipe(), new SplitRecipe(), new StripRecipe(), new TrimToEmptyRecipe(), new TrimToNullRecipe(), new TrimRecipe(), new UppercaseRecipe()});
    }

    @NullMarked
    public static class AbbreviateRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.abbreviate(String, int)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.abbreviate(String str, int maxWidth)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.commons.lang3.StringUtils.abbreviate(#{s:any(java.lang.String)}, #{width:any(int)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(1))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null || #{s}.length() <= #{width:any(int)} ? #{s} : #{s}.substring(0, #{width} - 3) + \"...\"").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils abbreviate(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CapitalizeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.capitalize(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.capitalize(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.commons.lang3.StringUtils.capitalize(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null || #{s}.isEmpty() || Character.isTitleCase(#{s}.charAt(0)) ? #{s} : Character.toTitleCase(#{s}.charAt(0)) + #{s}.substring(1)").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils capitalize(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DefaultStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.defaultString(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.defaultString(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.commons.lang3.StringUtils.defaultString(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects.toString(#{s:any(java.lang.String)}, \"\")").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils defaultString(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DefaultStringFallbackRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.defaultString(String, String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.defaultString(String str, String nullDefault)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.commons.lang3.StringUtils.defaultString(#{s:any(java.lang.String)}, #{nullDefault:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects.toString(#{s:any(java.lang.String)}, #{nullDefault:any(java.lang.String)})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils defaultString(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class DeleteWhitespaceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.deleteWhitespace(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.deleteWhitespace(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.commons.lang3.StringUtils.deleteWhitespace(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null ? null : #{s}.replaceAll(\"\\\\s+\", \"\")").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils deleteWhitespace(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EqualsIgnoreCaseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.equalsIgnoreCase(CharSequence, CharSequence)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.equalsIgnoreCase(CharSequence cs1, CharSequence cs2)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.commons.lang3.StringUtils.equalsIgnoreCase(#{s:any(java.lang.String)}, #{other:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(1))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null ? #{other:any(java.lang.String)} == null : #{s}.equalsIgnoreCase(#{other})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils equalsIgnoreCase(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class EqualsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.equals(CharSequence, CharSequence)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.equals(CharSequence cs1, CharSequence cs2)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.commons.lang3.StringUtils.equals(#{s:any(java.lang.String)}, #{other:any(java.lang.String)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"java.util.Objects.equals(#{s:any(java.lang.String)}, #{other:any(java.lang.String)})").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils equals(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class LowercaseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.lowerCase(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.lowerCase(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.commons.lang3.StringUtils.lowerCase(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null ? null : #{s}.toLowerCase()").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils lowerCase(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class RemoveEndRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.removeEnd(String, String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.removeEnd(String str, String remove)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.commons.lang3.StringUtils.removeEnd(#{s:any(java.lang.String)}, #{end:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(1))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null || #{s}.isEmpty() || #{end:any(java.lang.String)} == null || #{end}.isEmpty() || !#{s}.endsWith(#{end}) ? #{s} : #{s}.substring(0, #{s}.length() - #{end}.length())").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils removeEnd(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReplaceRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.replace(String, String, String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.replace(String text, String searchString, String replacement)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.commons.lang3.StringUtils.replace(#{s:any(java.lang.String)}, #{search:any(java.lang.String)}, #{replacement:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(1))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(2))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null || #{s}.isEmpty() || #{search:any(java.lang.String)} == null || #{search}.isEmpty() || #{replacement:any(java.lang.String)} == null ? #{s} : #{s}.replace(#{search}, #{replacement})").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils replace(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ReverseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.reverse(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.reverse(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.commons.lang3.StringUtils.reverse(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null ? null : new StringBuilder(#{s}).reverse().toString()").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils reverse(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class SplitRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.split(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.split(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.commons.lang3.StringUtils.split(#{s:any(java.lang.String)})").bindType("java.lang.String[]").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null ? null : #{s}.split(\"\\\\s+\")").bindType("java.lang.String[]").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils split(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class StripRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.strip(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.strip(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.commons.lang3.StringUtils.strip(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null ? null : #{s}.trim()").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils strip(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class TrimToEmptyRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.trimToEmpty(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.trimToEmpty(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.commons.lang3.StringUtils.trimToEmpty(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null ? \"\" : #{s}.trim()").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils trimToEmpty(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class TrimToNullRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.trimToNull(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.trimToNull(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.commons.lang3.StringUtils.trimToNull(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null || #{s}.trim().isEmpty() ? null : #{s}.trim()").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils trimToNull(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class TrimRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.trim(String)` with JDK provided API";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.trim(String str)` with JDK provided API.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.commons.lang3.StringUtils.trim(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null ? null : #{s}.trim()").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils trim(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class UppercaseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `StringUtils.upperCase(String)` with JDK internals";
        }

        public String getDescription() {
            return "Replace Apache Commons `StringUtils.upperCase(String str)` with JDK internals.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"org.apache.commons.lang3.StringUtils.upperCase(#{s:any(java.lang.String)})").bindType("java.lang.String").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (!new RepeatableArgumentMatcher().matches((Expression)matcher.parameter(0))) {
                            return super.visitMethodInvocation(elem, (Object)ctx);
                        }
                        this.maybeRemoveImport("org.apache.commons.lang3.StringUtils");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{s:any(java.lang.String)} == null ? null : #{s}.toUpperCase()").bindType("java.lang.String").build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.apache.commons.lang3.StringUtils", Boolean.valueOf(true)), new UsesMethod("org.apache.commons.lang3.StringUtils upperCase(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

