/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.codehaus.plexus;

import java.util.concurrent.atomic.AtomicReference;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.logging.AddLogger;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public class AbstractLogEnabledToSlf4j
extends Recipe {
    private static final String ABSTRACT_LOG_ENABLED = "org.codehaus.plexus.logging.AbstractLogEnabled";
    private static final MethodMatcher GET_LOGGER_MATCHER = new MethodMatcher("org.codehaus.plexus.logging.AbstractLogEnabled getLogger()", true);
    private static final String PLEXUS_LOGGER = "org.codehaus.plexus.logging.Logger";
    private static final MethodMatcher PLEXUS_LOGGER_MATCHER = new MethodMatcher("org.codehaus.plexus.logging.Logger *(..)");
    private static final String LOGGER_VARIABLE_NAME = "LOGGER";

    public String getDisplayName() {
        return "Migrate from Plexus `AbstractLogEnabled` to SLF4J";
    }

    public String getDescription() {
        return "Introduce a SLF4J `Logger` field and replace calls to `getLogger()` with calls to the field.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(ABSTRACT_LOG_ENABLED, Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = classDecl;
                if (TypeUtils.isAssignableTo((String)AbstractLogEnabledToSlf4j.ABSTRACT_LOG_ENABLED, (JavaType)cd.getType())) {
                    TypeTree anExtends = cd.getExtends();
                    if (anExtends != null && TypeUtils.isOfClassType((JavaType)anExtends.getType(), (String)AbstractLogEnabledToSlf4j.ABSTRACT_LOG_ENABLED)) {
                        this.maybeRemoveImport(AbstractLogEnabledToSlf4j.ABSTRACT_LOG_ENABLED);
                        cd = cd.withExtends(null);
                    }
                    if (new UsesMethod(PLEXUS_LOGGER_MATCHER).visitNonNull((Tree)cd, (Object)ctx, this.getCursor().getParentTreeCursor()) == cd) {
                        return cd;
                    }
                    cd = (J.ClassDeclaration)new JavaIsoVisitor<ExecutionContext>(){

                        public // Could not load outer class - annotation placement on inner may be incorrect
                        @Nullable J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                            if (multiVariable.getVariables().stream().map(J.VariableDeclarations.NamedVariable::getSimpleName).anyMatch("logger"::equalsIgnoreCase)) {
                                return null;
                            }
                            return super.visitVariableDeclarations(multiVariable, (Object)ctx);
                        }

                        public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
                            if ("logger".equals(identifier.getSimpleName())) {
                                return identifier.withSimpleName(AbstractLogEnabledToSlf4j.LOGGER_VARIABLE_NAME).withFieldType(identifier.getFieldType().withName(AbstractLogEnabledToSlf4j.LOGGER_VARIABLE_NAME));
                            }
                            return super.visitIdentifier(identifier, (Object)ctx);
                        }
                    }.visitNonNull((Tree)cd, (Object)ctx, this.getCursor().getParentTreeCursor());
                    this.maybeAddImport("org.slf4j.Logger");
                    this.maybeAddImport("org.slf4j.LoggerFactory");
                    cd = (J.ClassDeclaration)AddLogger.addSlf4jLogger((J.ClassDeclaration)cd, (String)AbstractLogEnabledToSlf4j.LOGGER_VARIABLE_NAME, (ExecutionContext)ctx).visitNonNull((Tree)cd, (Object)ctx, this.getCursor().getParentTreeCursor());
                    final AtomicReference loggerFieldReference = new AtomicReference();
                    new JavaIsoVisitor<AtomicReference<J.Identifier>>(){

                        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, AtomicReference<J.Identifier> ref) {
                            for (J.VariableDeclarations.NamedVariable var : multiVariable.getVariables()) {
                                if (!TypeUtils.isOfClassType((JavaType)var.getType(), (String)"org.slf4j.Logger")) continue;
                                ref.set(var.getName());
                            }
                            return super.visitVariableDeclarations(multiVariable, ref);
                        }
                    }.visitClassDeclaration(cd, loggerFieldReference);
                    cd = (J.ClassDeclaration)new JavaVisitor<ExecutionContext>(){

                        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                            J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                            if (GET_LOGGER_MATCHER.matches((MethodCall)mi)) {
                                return ((J.Identifier)loggerFieldReference.get()).withPrefix(mi.getPrefix());
                            }
                            if (PLEXUS_LOGGER_MATCHER.matches((MethodCall)mi)) {
                                return mi.getPadding().withSelect(JRightPadded.build((Object)mi.getSelect()));
                            }
                            return mi;
                        }
                    }.visitNonNull((Tree)cd, (Object)ctx, this.getCursor().getParentTreeCursor());
                    cd = (J.ClassDeclaration)new ChangeMethodName("org.codehaus.plexus.logging.Logger fatalError(..)", "error", Boolean.valueOf(false), Boolean.valueOf(false)).getVisitor().visitNonNull((Tree)cd, (Object)ctx, this.getCursor().getParentTreeCursor());
                    cd = (J.ClassDeclaration)new ChangeMethodName("org.codehaus.plexus.logging.Logger isFatalErrorEnabled(..)", "isErrorEnabled", Boolean.valueOf(false), Boolean.valueOf(false)).getVisitor().visitNonNull((Tree)cd, (Object)ctx, this.getCursor().getParentTreeCursor());
                    this.maybeRemoveImport(AbstractLogEnabledToSlf4j.PLEXUS_LOGGER);
                    cd = (J.ClassDeclaration)new ChangeType(AbstractLogEnabledToSlf4j.PLEXUS_LOGGER, "org.slf4j.Logger", Boolean.valueOf(false), null).getVisitor().visitNonNull((Tree)cd, (Object)ctx, this.getCursor().getParentTreeCursor());
                }
                return super.visitClassDeclaration(cd, (Object)ctx);
            }
        });
    }
}

