/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { EventEmitter } from '../event_emitter';
/**
 * The `outputs` function allows declaration of outputs in directives and
 * components.
 *
 * Initializes an output that can emit values to consumers of your
 * directive/component.
 *
 * @usageNotes
 * Initialize an output in your directive by declaring a
 * class field and initializing it with the `output()` function.
 *
 * ```ts
 * @Directive({..})
 * export class MyDir {
 *   nameChange = output<string>();     // OutputEmitter<string>
 *   onClick = output();                // OutputEmitter<void>
 * }
 * ```
 *
 * @developerPreview
 */
export function output(opts) {
    return new EventEmitter();
}
//# sourceMappingURL=data:application/json;base64,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