"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystemResolver = void 0;
const fs_1 = require("fs");
const path_1 = require("path");
const extensions_1 = require("../extensions");
function isFile(path) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            return (yield fs_1.promises.stat(path)).isFile();
        }
        catch (_a) {
            return false;
        }
    });
}
/**
 * Resolves file system paths to plugins.
 */
class FileSystemResolver {
    constructor(optionalExtensions = extensions_1.PluginExtensions) {
        this.optionalExtensions = optionalExtensions;
    }
    *enumerateCandidateSources(source) {
        yield (0, path_1.resolve)(source);
        for (const ext of this.optionalExtensions) {
            if (ext[0] !== '.') {
                yield (0, path_1.resolve)(`${source}.${ext}`);
            }
            else {
                yield (0, path_1.resolve)(source + ext);
            }
        }
    }
    canResolve(source) {
        return __awaiter(this, void 0, void 0, function* () {
            for (const candidate of this.enumerateCandidateSources(source)) {
                if (yield isFile(candidate)) {
                    return true;
                }
            }
            return false;
        });
    }
    resolve(source) {
        return __awaiter(this, void 0, void 0, function* () {
            for (const candidate of this.enumerateCandidateSources(source)) {
                if (yield isFile(candidate)) {
                    return candidate;
                }
            }
            throw new Error(`unable to resolve file from source: ${source}`);
        });
    }
}
exports.FileSystemResolver = FileSystemResolver;
//# sourceMappingURL=FileSystemResolver.js.map