"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkResolver = exports.NetworkLoadError = void 0;
const fs_1 = require("fs");
const got_1 = require("got");
const tmp_1 = require("tmp");
const url_1 = require("url");
class NetworkLoadError extends Error {
    constructor(response) {
        super(`failed to load plugin from '${response.url}'`);
        this.response = response;
    }
}
exports.NetworkLoadError = NetworkLoadError;
/**
 * Resolves plugins over the network to a local file.
 *
 * This plugin accepts only absolute HTTP URLs.
 */
class NetworkResolver {
    canResolve(source) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const url = new url_1.URL(source);
                return url.protocol === 'http:' || url.protocol === 'https:';
            }
            catch (_a) {
                return false;
            }
        });
    }
    resolve(source) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield (0, got_1.get)(source, { followRedirect: true });
            if (response.statusCode !== 200) {
                throw new NetworkLoadError(response);
            }
            const filename = (0, tmp_1.tmpNameSync)({ postfix: '.js' });
            yield fs_1.promises.writeFile(filename, response.body);
            return filename;
        });
    }
}
exports.NetworkResolver = NetworkResolver;
//# sourceMappingURL=NetworkResolver.js.map