"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generate = exports.parse = void 0;
const recast = require("recast");
function parse(code, options, parse) {
    return recast.parse(code, {
        parser: {
            parse(code) {
                return parse(code, Object.assign(Object.assign({}, options), { tokens: true }));
            },
        },
    });
}
exports.parse = parse;
function generate(ast) {
    return recast.print(ast, { sourceMapName: 'map.json' });
}
exports.generate = generate;
function default_1() {
    return {
        parserOverride: parse,
        generatorOverride: generate,
    };
}
exports.default = default_1;
//# sourceMappingURL=RecastPlugin.js.map