import { Matcher } from './Matcher';
export interface CaptureBase {
    [key: string]: any;
}
export declare class CapturedMatcher<C, M = C> extends Matcher<M> {
    private readonly matcher;
    private _current?;
    private _currentKeys?;
    constructor(matcher?: Matcher<C>);
    get current(): C | undefined;
    get currentKeys(): ReadonlyArray<PropertyKey> | undefined;
    matchValue(value: unknown, keys: ReadonlyArray<PropertyKey>): value is M;
    protected capture(value: C, keys: ReadonlyArray<PropertyKey>): void;
}
export declare function capture<C, M = C>(matcher?: Matcher<C>): CapturedMatcher<C, M>;
